/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.WebRequest;

@Controller
@RequestMapping(path={"/admin"})
public class AdminController {
    private static Logger logger = LoggerFactory.getLogger(AdminController.class);

    @RequestMapping(path={"/TokenServlet"}, method={RequestMethod.GET})
    public String showTokens(WebRequest req, Model model, @RequestParam Map<String, String> attributes) throws IOException {
        RefreshToken refreshToken;
        String timeOffset = attributes.get("timeOffset");
        if (!StringUtils.isEmpty((Object)timeOffset)) {
            int offset;
            try {
                offset = Integer.parseInt(timeOffset, 10);
            }
            catch (NumberFormatException e) {
                offset = 0;
            }
            Time.setOffset((int)offset);
        }
        RefreshableKeycloakSecurityContext ctx = (RefreshableKeycloakSecurityContext)req.getAttribute(KeycloakSecurityContext.class.getName(), 0);
        String accessTokenPretty = JsonSerialization.writeValueAsPrettyString((Object)ctx.getToken());
        try {
            refreshToken = (RefreshToken)new JWSInput(ctx.getRefreshToken()).readJsonContent(RefreshToken.class);
        }
        catch (JWSInputException e) {
            throw new IOException(e);
        }
        String refreshTokenPretty = JsonSerialization.writeValueAsPrettyString((Object)refreshToken);
        model.addAttribute("accessToken", (Object)accessTokenPretty);
        model.addAttribute("refreshToken", (Object)refreshTokenPretty);
        model.addAttribute("accessTokenString", (Object)ctx.getTokenString());
        return "tokens";
    }

    @RequestMapping(path={"/SessionServlet"}, method={RequestMethod.GET})
    public String sessionServlet(WebRequest webRequest, Model model) {
        String counterString = (String)webRequest.getAttribute("counter", 1);
        int counter = 0;
        try {
            counter = Integer.parseInt(counterString, 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        model.addAttribute("counter", (Object)counter);
        webRequest.setAttribute("counter", (Object)Integer.toString(counter + 1), 1);
        return "session";
    }

    @RequestMapping(path={"/LinkServlet"}, method={RequestMethod.GET})
    public String tokenController(WebRequest webRequest, @RequestParam Map<String, String> attributes, Model model) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpSession httpSession = attr.getRequest().getSession(true);
        String responseAttr = attributes.get("response");
        if (StringUtils.isEmpty((Object)responseAttr)) {
            MessageDigest md;
            String provider = attributes.get("provider");
            String realm = attributes.get("realm");
            KeycloakSecurityContext keycloakSession = (KeycloakSecurityContext)webRequest.getAttribute(KeycloakSecurityContext.class.getName(), 0);
            AccessToken token = keycloakSession.getToken();
            String clientId = token.getIssuedFor();
            String nonce = UUID.randomUUID().toString();
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            String input = nonce + token.getSessionState() + clientId + provider;
            byte[] check = md.digest(input.getBytes(StandardCharsets.UTF_8));
            String hash = Base64Url.encode((byte[])check);
            httpSession.setAttribute("hash", (Object)hash);
            String redirectUri = KeycloakUriBuilder.fromUri((String)"http://localhost:8280/admin/LinkServlet").queryParam("response", new Object[]{"true"}).build(new Object[0]).toString();
            String accountLinkUrl = KeycloakUriBuilder.fromUri((String)"http://localhost:8180/").path("/auth/realms/{realm}/broker/{provider}/link").queryParam("nonce", new Object[]{nonce}).queryParam("hash", new Object[]{hash}).queryParam("client_id", new Object[]{token.getIssuedFor()}).queryParam("redirect_uri", new Object[]{redirectUri}).build(new Object[]{realm, provider}).toString();
            return "redirect:" + accountLinkUrl;
        }
        String error = attributes.get("link_error");
        if (StringUtils.isEmpty((Object)error)) {
            model.addAttribute("error", (Object)"Account linked");
        } else {
            model.addAttribute("error", (Object)error);
        }
        return "linking";
    }
}

