/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.photoz.album;

import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.keycloak.example.photoz.CustomDatabase;
import org.keycloak.example.photoz.entity.Album;

@Path(value="/profile")
public class ProfileService {
    private static final String PROFILE_VIEW = "profile:view";
    private CustomDatabase customDatabase = CustomDatabase.create();

    @GET
    @Produces(value={"application/json"})
    public Response view(@Context HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        List<Album> albums = this.customDatabase.findByUserId(userPrincipal.getName());
        return Response.ok((Object)new Profile(userPrincipal.getName(), albums.size())).build();
    }

    public static class Profile {
        private String userName;
        private int totalAlbums;

        public Profile(String name, int totalAlbums) {
            this.userName = name;
            this.totalAlbums = totalAlbums;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getTotalAlbums() {
            return this.totalAlbums;
        }
    }
}

