/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.photoz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.keycloak.example.photoz.entity.Album;
import org.keycloak.example.photoz.entity.Photo;

public class CustomDatabase {
    private static final CustomDatabase INSTANCE = new CustomDatabase();
    private List<Album> albums = new ArrayList<Album>();
    private List<Photo> photos;
    private Long lastIndex = 0L;

    public static final CustomDatabase create() {
        return INSTANCE;
    }

    private CustomDatabase() {
    }

    public List<Album> getAll() {
        return this.albums;
    }

    public void addAlbum(Album a) {
        Long l = this.lastIndex;
        Long l2 = this.lastIndex = Long.valueOf(this.lastIndex + 1L);
        a.setId(l);
        this.albums.add(a);
    }

    public void remove(Album albumToRemove) {
        Iterator<Album> iter = this.albums.iterator();
        while (iter.hasNext()) {
            Album a = iter.next();
            if (!a.getId().equals(albumToRemove.getId())) continue;
            iter.remove();
        }
    }

    public Album findById(Long id) {
        for (Album a : this.albums) {
            if (!a.getId().equals(id)) continue;
            return a;
        }
        return null;
    }

    public Album findByName(String name) {
        for (Album a : this.albums) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public List<Album> findByUserId(String userId) {
        ArrayList<Album> result = new ArrayList<Album>();
        for (Album a : this.albums) {
            if (!a.getUserId().equals(userId)) continue;
            result.add(a);
        }
        return result;
    }

    public int cleanAll() {
        int result = this.albums.size() + this.photos.size();
        this.albums.clear();
        this.photos.clear();
        return result;
    }
}

