/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.photoz.album;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthorizationContext;
import org.keycloak.authorization.client.resource.ProtectionResource;
import org.keycloak.example.photoz.CustomDatabase;
import org.keycloak.example.photoz.entity.Album;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

@Path(value="/album")
public class AlbumService {
    private final Logger log = Logger.getLogger(AlbumService.class);
    public static final String SCOPE_ALBUM_VIEW = "album:view";
    public static final String SCOPE_ALBUM_DELETE = "album:delete";
    private CustomDatabase customDatabase = CustomDatabase.create();
    @Context
    private HttpServletRequest request;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(Album newAlbum, @QueryParam(value="user") String invalidUser, @Context HttpHeaders headers) {
        this.printAuthHeaders(headers);
        String userId = this.request.getUserPrincipal().getName();
        if (invalidUser != null) {
            userId = invalidUser;
        }
        newAlbum.setUserId(userId);
        this.log.debug((Object)("PERSISTING " + newAlbum));
        this.customDatabase.addAlbum(newAlbum);
        try {
            this.createProtectedResource(newAlbum);
        }
        catch (RuntimeException e) {
            this.log.debug((Object)("ERROR " + e));
            this.customDatabase.remove(newAlbum);
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
        return Response.ok((Object)newAlbum).build();
    }

    @Path(value="{name}")
    @DELETE
    public Response delete(@PathParam(value="name") String name, @Context HttpHeaders headers) {
        this.printAuthHeaders(headers);
        Album album = this.customDatabase.findByName(name);
        try {
            this.deleteProtectedResource(album);
            this.customDatabase.remove(album);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not delete album.", e);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    public Response findAll(@QueryParam(value="getAll") Boolean getAll) {
        if (getAll != null && getAll.booleanValue()) {
            return Response.ok(this.customDatabase.getAll()).build();
        }
        return Response.ok(this.customDatabase.findByUserId(this.request.getUserPrincipal().getName())).build();
    }

    @GET
    @Path(value="{name}")
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="name") String name) {
        Album result = this.customDatabase.findByName(name);
        if (result == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)result).build();
    }

    private void createProtectedResource(Album album) {
        this.log.debug((Object)("Creating ProtectedResource for " + album));
        try {
            HashSet<ScopeRepresentation> scopes = new HashSet<ScopeRepresentation>();
            scopes.add(new ScopeRepresentation(SCOPE_ALBUM_VIEW));
            scopes.add(new ScopeRepresentation(SCOPE_ALBUM_DELETE));
            ResourceRepresentation albumResource = new ResourceRepresentation(album.getName(), scopes, "/album/" + album.getName(), "http://photoz.com/album");
            albumResource.setOwner(album.getUserId());
            if (album.isUserManaged()) {
                albumResource.setOwnerManagedAccess(Boolean.valueOf(true));
            }
            this.getAuthzClient().protection().resource().create(albumResource);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not register protected resource.", e);
        }
    }

    private void deleteProtectedResource(Album album) {
        String uri = "/album/" + album.getName();
        try {
            ProtectionResource protection = this.getAuthzClient().protection();
            List search = protection.resource().findByUri(uri);
            if (search.isEmpty()) {
                throw new RuntimeException("Could not find protected resource with URI [" + uri + "]");
            }
            protection.resource().delete(((ResourceRepresentation)search.get(0)).getId());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Could not search protected resource.", e);
        }
    }

    private AuthzClient getAuthzClient() {
        return this.getAuthorizationContext().getClient();
    }

    private ClientAuthorizationContext getAuthorizationContext() {
        return (ClientAuthorizationContext)ClientAuthorizationContext.class.cast(this.getKeycloakSecurityContext().getAuthorizationContext());
    }

    private KeycloakSecurityContext getKeycloakSecurityContext() {
        return (KeycloakSecurityContext)KeycloakSecurityContext.class.cast(this.request.getAttribute(KeycloakSecurityContext.class.getName()));
    }

    private void printAuthHeaders(HttpHeaders headers) {
        this.log.debug((Object)"-----------------Authorization headers--------------------------");
        for (String authHeader : headers.getRequestHeader("Authorization")) {
            this.log.debug((Object)authHeader);
        }
    }
}

