/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.io.IOException;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.jboss.marshalling.commons.GenericJBossMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.junit.rules.ExternalResource;
import org.keycloak.Config;
import org.keycloak.models.map.storage.hotRod.common.HotRodUtils;

public class HotRodServerRule
extends ExternalResource {
    protected HotRodServer hotRodServer;
    protected HotRodServer hotRodServer2;
    protected RemoteCacheManager remoteCacheManager;
    protected DefaultCacheManager hotRodCacheManager;
    protected DefaultCacheManager hotRodCacheManager2;

    protected void after() {
        if (this.remoteCacheManager != null) {
            this.remoteCacheManager.stop();
        }
    }

    public void createEmbeddedHotRodServer(Config.Scope config) {
        try {
            this.hotRodCacheManager = new DefaultCacheManager("hotrod/hotrod1.xml");
            this.hotRodCacheManager2 = new DefaultCacheManager("hotrod/hotrod2.xml");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HotRodServerConfiguration build = new HotRodServerConfigurationBuilder().build();
        this.hotRodServer = new HotRodServer();
        this.hotRodServer.start((ProtocolServerConfiguration)build, (EmbeddedCacheManager)this.hotRodCacheManager);
        HotRodServerConfiguration build2 = ((HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().port(11333)).build();
        this.hotRodServer2 = new HotRodServer();
        this.hotRodServer2.start((ProtocolServerConfiguration)build2, (EmbeddedCacheManager)this.hotRodCacheManager2);
        ConfigurationBuilder remoteBuilder = new ConfigurationBuilder();
        remoteBuilder.marshaller((Marshaller)new GenericJBossMarshaller());
        Configuration cfg = remoteBuilder.addServers(this.hotRodServer.getHost() + ":" + this.hotRodServer.getPort() + ";" + this.hotRodServer2.getHost() + ":" + this.hotRodServer2.getPort()).build();
        this.remoteCacheManager = new RemoteCacheManager(cfg);
        boolean async = config.getBoolean("async", Boolean.valueOf(false));
        this.createKeycloakCaches(async, "sessions", "offlineSessions", "clientSessions", "offlineClientSessions", "loginFailures", "work", "actionTokens");
        this.getCaches("sessions", "offlineSessions", "clientSessions", "offlineClientSessions", "loginFailures", "work", "actionTokens");
    }

    public void createHotRodMapStoreServer() {
        this.hotRodCacheManager = this.configureHotRodCacheManager("hotrod/infinispan.xml");
        this.hotRodServer = new HotRodServer();
        HotRodUtils.createHotRodMapStoreServer((HotRodServer)this.hotRodServer, (DefaultCacheManager)this.hotRodCacheManager, (int)11444);
        ConfigurationBuilder remoteBuilder = new ConfigurationBuilder();
        Configuration cfg = remoteBuilder.addServers(this.hotRodServer.getHost() + ":" + this.hotRodServer.getPort()).build();
        this.remoteCacheManager = new RemoteCacheManager(cfg);
    }

    private DefaultCacheManager configureHotRodCacheManager(String configPath) {
        DefaultCacheManager manager = null;
        try {
            manager = new DefaultCacheManager(configPath);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
        return manager;
    }

    private void getCaches(String ... cache) {
        for (String c : cache) {
            this.hotRodCacheManager.getCache(c, true);
            this.hotRodCacheManager2.getCache(c, true);
        }
    }

    private void createKeycloakCaches(boolean async, String ... cache) {
        org.infinispan.configuration.cache.ConfigurationBuilder sessionConfigBuilder1 = HotRodServerRule.createCacheConfigurationBuilder();
        org.infinispan.configuration.cache.ConfigurationBuilder sessionConfigBuilder2 = HotRodServerRule.createCacheConfigurationBuilder();
        sessionConfigBuilder1.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        sessionConfigBuilder2.clustering().cacheMode(async ? CacheMode.REPL_ASYNC : CacheMode.REPL_SYNC);
        sessionConfigBuilder1.sites().addBackup().site("site-2").backupFailurePolicy(BackupFailurePolicy.IGNORE).strategy(BackupConfiguration.BackupStrategy.SYNC).replicationTimeout(15000L).enabled(true);
        sessionConfigBuilder2.sites().addBackup().site("site-1").backupFailurePolicy(BackupFailurePolicy.IGNORE).strategy(BackupConfiguration.BackupStrategy.SYNC).replicationTimeout(15000L).enabled(true);
        org.infinispan.configuration.cache.Configuration sessionCacheConfiguration1 = sessionConfigBuilder1.build();
        org.infinispan.configuration.cache.Configuration sessionCacheConfiguration2 = sessionConfigBuilder2.build();
        for (String c : cache) {
            this.hotRodCacheManager.defineConfiguration(c, sessionCacheConfiguration1);
            this.hotRodCacheManager2.defineConfiguration(c, sessionCacheConfiguration2);
        }
    }

    public static org.infinispan.configuration.cache.ConfigurationBuilder createCacheConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.encoding().mediaType("application/x-jboss-marshalling");
        return builder;
    }

    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    public HotRodServer getHotRodServer() {
        return this.hotRodServer;
    }

    public HotRodServer getHotRodServer2() {
        return this.hotRodServer2;
    }

    public DefaultCacheManager getHotRodCacheManager() {
        return this.hotRodCacheManager;
    }

    public DefaultCacheManager getHotRodCacheManager2() {
        return this.hotRodCacheManager2;
    }
}

