/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.common.util.SystemEnvProperties;

public class Config
implements Config.ConfigProvider {
    private final Properties systemProperties = new SystemEnvProperties();
    private final Map<String, String> defaultProperties = new HashMap<String, String>();
    private final ThreadLocal<Map<String, String>> properties = new ThreadLocal<Map<String, String>>(){

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>();
        }
    };
    private final BooleanSupplier useGlobalConfigurationFunc;

    public Config(BooleanSupplier useGlobalConfigurationFunc) {
        this.useGlobalConfigurationFunc = useGlobalConfigurationFunc;
    }

    void reset() {
        if (this.useGlobalConfigurationFunc.getAsBoolean()) {
            this.defaultProperties.clear();
        } else {
            this.properties.remove();
        }
    }

    public String getProvider(String spiName) {
        return this.getConfig().get(spiName + ".provider");
    }

    public Map<String, String> getConfig() {
        return this.useGlobalConfigurationFunc.getAsBoolean() ? this.defaultProperties : this.properties.get();
    }

    private String replaceProperties(String value) {
        return StringPropertyReplacer.replaceProperties((String)value, (Properties)this.systemProperties);
    }

    public Config.Scope scope(String ... scope) {
        StringBuilder sb = new StringBuilder();
        for (String s : scope) {
            sb.append(s);
            sb.append(".");
        }
        return new MapConfigScope(sb.toString());
    }

    public SpiConfig spi(String spiName) {
        return new SpiConfig(spiName + ".");
    }

    public String toString() {
        return this.getConfig().entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).map(e -> (String)e.getKey() + " = " + (String)e.getValue()).collect(Collectors.joining("\n    "));
    }

    private class MapConfigScope
    extends Config.SystemPropertiesScope {
        public MapConfigScope(String prefix) {
            super(prefix);
        }

        public String get(String key, String defaultValue) {
            String v = Config.this.replaceProperties(Config.this.getConfig().get(this.prefix + key));
            if (v == null || v.isEmpty()) {
                v = System.getProperty("keycloak." + this.prefix + key, defaultValue);
            }
            return v != null && !v.isEmpty() ? v : null;
        }

        public Config.Scope scope(String ... scope) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.prefix);
            for (String s : scope) {
                sb.append(s);
                sb.append(".");
            }
            return new MapConfigScope(sb.toString());
        }
    }

    public class ProviderConfig {
        private final SpiConfig spiConfig;
        private final String prefix;

        public ProviderConfig(SpiConfig spiConfig, String prefix) {
            this.spiConfig = spiConfig;
            this.prefix = prefix;
        }

        public ProviderConfig config(String key, String value) {
            if (value == null) {
                Config.this.getConfig().remove(this.prefix + key);
            } else {
                Config.this.getConfig().put(this.prefix + key, value);
            }
            return this;
        }

        public ProviderConfig provider(String provider) {
            return this.spiConfig.provider(provider);
        }

        public SpiConfig spi(String spiName) {
            return new SpiConfig(spiName + ".");
        }
    }

    public class SpiConfig {
        private final String prefix;

        public SpiConfig(String prefix) {
            this.prefix = prefix;
        }

        public ProviderConfig provider(String provider) {
            return new ProviderConfig(this, this.prefix + provider + ".");
        }

        public SpiConfig defaultProvider(String defaultProviderId) {
            return this.config("provider", defaultProviderId);
        }

        public SpiConfig config(String key, String value) {
            if (value == null) {
                Config.this.getConfig().remove(this.prefix + key);
            } else {
                Config.this.getConfig().put(this.prefix + key, value);
            }
            return this;
        }

        public SpiConfig spi(String spiName) {
            return new SpiConfig(spiName + ".");
        }
    }
}

