/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.undertow;

import io.undertow.UndertowMessages;
import io.undertow.jsp.HackInstanceManager;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ServletInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.annotation.WebServlet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tomcat.InstanceManager;
import org.arquillian.undertow.UndertowContainerConfiguration;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.keycloak.testsuite.utils.undertow.SimpleWebXmlParser;
import org.keycloak.testsuite.utils.undertow.UndertowWarClassLoader;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class UndertowDeployerHelper {
    private static final Logger log = Logger.getLogger(UndertowDeployerHelper.class);

    public DeploymentInfo getDeploymentInfo(UndertowContainerConfiguration config, WebArchive archive) {
        return this.getDeploymentInfo(config, archive, null);
    }

    public DeploymentInfo getDeploymentInfo(UndertowContainerConfiguration config, WebArchive archive, DeploymentInfo di) {
        String archiveName = archive.getName();
        String contextPath = this.getContextPath(archive);
        String appContextUrl = "http://" + config.getBindAddress() + ":" + config.getBindHttpPort() + contextPath;
        try {
            if (di == null) {
                di = new DeploymentInfo();
            }
            UndertowWarClassLoader classLoader = new UndertowWarClassLoader(Thread.currentThread().getContextClassLoader(), (Archive<?>)archive);
            di.setClassLoader((ClassLoader)classLoader);
            di.setDeploymentName(archiveName);
            di.setContextPath(contextPath);
            ResourceManager undertowResourcesWrapper = this.getResourceManager(appContextUrl, archive);
            di.setResourceManager(undertowResourcesWrapper);
            if (archive.contains("/WEB-INF/web.xml")) {
                Document webXml = this.loadXML(archive.get("/WEB-INF/web.xml").getAsset().openStream());
                new SimpleWebXmlParser().parseWebXml(webXml, di);
            }
            di.addServlet(JspServletBuilder.createServlet((String)"Default Jsp Servlet", (String)"*.jsp"));
            di.addWelcomePages(new String[]{"index.html", "index.jsp"});
            JspServletBuilder.setupDeployment((DeploymentInfo)di, new HashMap(), new HashMap(), (InstanceManager)new HackInstanceManager());
            this.addAnnotatedServlets(di, (Archive<?>)archive);
            return di;
        }
        catch (IOException | IllegalArgumentException ioe) {
            throw new RuntimeException("Error deploying " + archive.getName(), ioe);
        }
    }

    private ResourceManager getResourceManager(final String appServerRoot, final WebArchive archive) throws IOException {
        return new ResourceManager(){

            public Resource getResource(String path) throws IOException {
                if (path == null || path.isEmpty()) {
                    return null;
                }
                final Node node = archive.get(path);
                if (node == null) {
                    log.warnf("Application '%s' did not found resource on path %s", (Object)archive.getName(), (Object)path);
                    return null;
                }
                URL contextUrl = new URL(appServerRoot);
                URL myResourceUrl = new URL(contextUrl.getProtocol(), contextUrl.getHost(), contextUrl.getPort(), path, new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) throws IOException {
                        return new URLConnection(u){

                            @Override
                            public void connect() throws IOException {
                            }

                            @Override
                            public InputStream getInputStream() throws IOException {
                                return node.getAsset().openStream();
                            }
                        };
                    }
                });
                return new URLResource(myResourceUrl, myResourceUrl.openConnection(), path);
            }

            public boolean isResourceChangeListenerSupported() {
                return false;
            }

            public void registerResourceChangeListener(ResourceChangeListener listener) {
                throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
            }

            public void removeResourceChangeListener(ResourceChangeListener listener) {
                throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
            }

            public void close() throws IOException {
            }
        };
    }

    private Document loadXML(InputStream is) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            return dBuilder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAnnotatedServlets(DeploymentInfo di, Archive<?> archive) {
        Map classNodes = archive.getContent(path -> {
            String stringPath = path.get();
            return stringPath.startsWith("/WEB-INF/classes") && stringPath.endsWith("class");
        });
        for (Map.Entry entry : classNodes.entrySet()) {
            ClassAsset classAsset;
            Class clazz;
            WebServlet annotation;
            Node n = (Node)entry.getValue();
            if (!(n.getAsset() instanceof ClassAsset) || (annotation = (clazz = (classAsset = (ClassAsset)n.getAsset()).getSource()).getAnnotation(WebServlet.class)) == null) continue;
            ServletInfo undertowServlet = new ServletInfo(clazz.getSimpleName(), clazz);
            String[] mappings = annotation.value();
            if (mappings != null) {
                for (String urlPattern : mappings) {
                    undertowServlet.addMapping(urlPattern);
                }
            }
            di.addServlet(undertowServlet);
        }
    }

    private String getContextPath(WebArchive archive) {
        if (archive.contains("/META-INF/context.xml") && archive.get("/META-INF/context.xml").getAsset() instanceof StringAsset) {
            StringAsset asset = (StringAsset)archive.get("/META-INF/context.xml").getAsset();
            return asset.getSource().split("path=\"")[1].split("\"")[0];
        }
        return "/".concat(archive.getName().replace(".war", ""));
    }
}

