/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.undertow;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.LoginConfig;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.ServletSessionConfig;
import io.undertow.servlet.api.WebResourceCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.DispatcherType;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SimpleWebXmlParser {
    private static final Logger log = Logger.getLogger(SimpleWebXmlParser.class);

    SimpleWebXmlParser() {
    }

    void parseWebXml(Document webXml, DeploymentInfo di) {
        try {
            ElementWrapper sessionCfg;
            DocumentWrapper document = new DocumentWrapper(webXml);
            if (di.getServlets().get("ResteasyServlet") == null) {
                HashMap<String, String> servletMappings = new HashMap<String, String>();
                List<ElementWrapper> sm = document.getElementsByTagName("servlet-mapping");
                for (ElementWrapper elementWrapper : sm) {
                    String string = elementWrapper.getElementByTagName("servlet-name").getText();
                    String string2 = elementWrapper.getElementByTagName("url-pattern").getText();
                    servletMappings.put(string, string2);
                }
                List<ElementWrapper> servlets = document.getElementsByTagName("servlet");
                Iterator iterator = servlets.iterator();
                while (iterator.hasNext()) {
                    ElementWrapper elementWrapper = (ElementWrapper)iterator.next();
                    String string = elementWrapper.getElementByTagName("servlet-name").getText();
                    ElementWrapper elementWrapper2 = elementWrapper.getElementByTagName("servlet-class");
                    String servletClass = elementWrapper2 == null ? string : elementWrapper2.getText();
                    ElementWrapper loadOnStartupEw = elementWrapper.getElementByTagName("load-on-startup");
                    Integer loadOnStartup = loadOnStartupEw == null ? null : Integer.valueOf(loadOnStartupEw.getText());
                    Class<?> servletClazz = Class.forName(servletClass, false, di.getClassLoader());
                    ServletInfo undertowServlet = new ServletInfo(string, (Class)servletClazz);
                    if (servletMappings.containsKey(string)) {
                        undertowServlet.addMapping((String)servletMappings.get(string));
                        undertowServlet.setLoadOnStartup(loadOnStartup);
                        di.addServlet(undertowServlet);
                        continue;
                    }
                    log.warnf("Missing servlet-mapping for '%s'", (Object)string);
                }
            }
            HashMap<String, String> filterMappings = new HashMap<String, String>();
            List<ElementWrapper> fm = document.getElementsByTagName("filter-mapping");
            for (ElementWrapper elementWrapper : fm) {
                String string = elementWrapper.getElementByTagName("filter-name").getText();
                String string3 = elementWrapper.getElementByTagName("url-pattern").getText();
                filterMappings.put(string, string3);
            }
            List<ElementWrapper> filters = document.getElementsByTagName("filter");
            for (ElementWrapper elementWrapper : filters) {
                String string = elementWrapper.getElementByTagName("filter-name").getText();
                String string4 = elementWrapper.getElementByTagName("filter-class").getText();
                Class<?> filterClazz = Class.forName(string4, false, di.getClassLoader());
                FilterInfo undertowFilter = new FilterInfo(string, filterClazz);
                List<ElementWrapper> initParams = elementWrapper.getElementsByTagName("init-param");
                for (ElementWrapper initParam : initParams) {
                    String paramName = initParam.getElementByTagName("param-name").getText();
                    String paramValue = initParam.getElementByTagName("param-value").getText();
                    undertowFilter.addInitParam(paramName, paramValue);
                }
                di.addFilter(undertowFilter);
                if (filterMappings.containsKey(string)) {
                    di.addFilterUrlMapping(string, (String)filterMappings.get(string), DispatcherType.REQUEST);
                    continue;
                }
                log.warnf("Missing filter-mapping for '%s'", (Object)string);
            }
            List<ElementWrapper> list = document.getElementsByTagName("context-param");
            for (ElementWrapper elementWrapper : list) {
                String string = elementWrapper.getElementByTagName("param-name").getText();
                String paramValue = elementWrapper.getElementByTagName("param-value").getText();
                di.addInitParameter(string, paramValue);
            }
            List<ElementWrapper> list2 = document.getElementsByTagName("security-role");
            for (ElementWrapper elementWrapper : list2) {
                String roleName = elementWrapper.getElementByTagName("role-name").getText();
                di.addSecurityRole(roleName);
            }
            List<ElementWrapper> list3 = document.getElementsByTagName("security-constraint");
            for (ElementWrapper constraint : list3) {
                String urlPattern = constraint.getElementByTagName("web-resource-collection").getElementByTagName("url-pattern").getText();
                ElementWrapper authCsnt = constraint.getElementByTagName("auth-constraint");
                String roleName = authCsnt == null ? null : authCsnt.getElementByTagName("role-name").getText();
                SecurityConstraint undertowConstraint = new SecurityConstraint();
                WebResourceCollection collection = new WebResourceCollection();
                collection.addUrlPattern(urlPattern);
                undertowConstraint.addWebResourceCollection(collection);
                if (roleName != null) {
                    undertowConstraint.addRoleAllowed(roleName);
                } else {
                    undertowConstraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
                }
                di.addSecurityConstraint(undertowConstraint);
            }
            ElementWrapper elementWrapper = document.getElementByTagName("login-config");
            if (elementWrapper != null) {
                String mech = elementWrapper.getElementByTagName("auth-method").getText();
                String realmName = elementWrapper.getElementByTagName("realm-name").getText();
                ElementWrapper form = elementWrapper.getElementByTagName("form-login-config");
                if (form != null) {
                    String loginPage = form.getElementByTagName("form-login-page").getText();
                    String errorPage = form.getElementByTagName("form-error-page").getText();
                    di.setLoginConfig(new LoginConfig(mech, realmName, loginPage, errorPage));
                } else {
                    di.setLoginConfig(new LoginConfig(realmName).addFirstAuthMethod(mech));
                }
            }
            if ((sessionCfg = document.getElementByTagName("session-config")) != null) {
                ElementWrapper cookieConfig = sessionCfg.getElementByTagName("cookie-config");
                String cookieName = cookieConfig.getElementByTagName("name").getText();
                ServletSessionConfig cfg = new ServletSessionConfig();
                if (cookieConfig.getElementByTagName("http-only") != null) {
                    cfg.setHttpOnly(Boolean.parseBoolean(cookieConfig.getElementByTagName("http-only").getText()));
                }
                cfg.setName(cookieName);
                di.setServletSessionConfig(cfg);
            }
            List<ElementWrapper> errorPages = document.getElementsByTagName("error-page");
            for (ElementWrapper errorPageWrapper : errorPages) {
                String location = errorPageWrapper.getElementByTagName("location").getText();
                ErrorPage errorPage = errorPageWrapper.getElementByTagName("error-code") != null ? new ErrorPage(location, Integer.parseInt(errorPageWrapper.getElementByTagName("error-code").getText())) : new ErrorPage(location);
                di.addErrorPage(errorPage);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        catch (NullPointerException npe) {
            throw new RuntimeException("Error parsing web.xml of " + di.getDeploymentName(), npe);
        }
    }

    private static class DocumentWrapper
    extends XmlWrapper {
        private final Document document;

        public DocumentWrapper(Document document) {
            this.document = document;
        }

        @Override
        List<ElementWrapper> getElementsByTagName(String tagName) {
            NodeList nl = this.document.getElementsByTagName(tagName);
            return this.getElementsFromNodeList(nl);
        }

        @Override
        ElementWrapper getElementByTagName(String tagName) {
            NodeList nl = this.document.getElementsByTagName(tagName);
            return this.getElementFromNodeList(nl);
        }
    }

    private static class ElementWrapper
    extends XmlWrapper {
        private final Element element;

        public ElementWrapper(Element element) {
            this.element = element;
        }

        @Override
        public List<ElementWrapper> getElementsByTagName(String tagName) {
            NodeList nl = this.element.getElementsByTagName(tagName);
            return this.getElementsFromNodeList(nl);
        }

        @Override
        public ElementWrapper getElementByTagName(String tagName) {
            NodeList nl = this.element.getElementsByTagName(tagName);
            return this.getElementFromNodeList(nl);
        }

        public String getText() {
            return this.element.getTextContent();
        }
    }

    private static abstract class XmlWrapper {
        private XmlWrapper() {
        }

        abstract List<ElementWrapper> getElementsByTagName(String var1);

        abstract ElementWrapper getElementByTagName(String var1);

        List<ElementWrapper> getElementsFromNodeList(NodeList nl) {
            LinkedList<ElementWrapper> result = new LinkedList<ElementWrapper>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                result.add(new ElementWrapper((Element)node));
            }
            return result;
        }

        ElementWrapper getElementFromNodeList(NodeList nl) {
            if (nl.getLength() > 0) {
                return new ElementWrapper((Element)nl.item(0));
            }
            return null;
        }
    }
}

