/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.tls;

import java.io.FileInputStream;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class TLSUtils {
    private static final TrustManager TRUST_ALL_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };

    private TLSUtils() {
    }

    public static SSLContext initializeTLS() {
        try {
            String keystorePath = System.getProperty("dependency.keystore");
            if (keystorePath == null) {
                keystorePath = Paths.get(TLSUtils.class.getResource("/keycloak.jks").toURI()).toAbsolutePath().toString();
            }
            KeyStore keystore = KeyStore.getInstance("jks");
            try (FileInputStream is = new FileInputStream(keystorePath);){
                keystore.load(is, "secret".toCharArray());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keystore, "secret".toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            String truststorePath = System.getProperty("dependency.truststore");
            if (truststorePath == null) {
                truststorePath = Paths.get(TLSUtils.class.getResource("/keycloak.truststore").toURI()).toAbsolutePath().toString();
            }
            KeyStore truststore = KeyStore.getInstance("jks");
            try (FileInputStream is = new FileInputStream(truststorePath);){
                truststore.load(is, "secret".toCharArray());
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(truststore);
            TrustManager[] trustManagers = new TrustManager[trustManagerFactory.getTrustManagers().length + 1];
            for (int i = 0; i < trustManagerFactory.getTrustManagers().length; ++i) {
                trustManagers[i] = trustManagerFactory.getTrustManagers()[i];
            }
            trustManagers[trustManagers.length - 1] = TRUST_ALL_MANAGER;
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize TLS", e);
        }
    }
}

