/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.fuse;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.logging.Logger;
import org.junit.Assert;

public class FuseUtils {
    private static final Logger log = Logger.getLogger(FuseUtils.class);
    private static boolean initiated = false;
    private static final String managementUser = System.getProperty("app.server.management.user", "admin");
    private static final String managementPassword = System.getProperty("app.server.management.password", "password");
    private static final String additionalFuseRepos = System.getProperty("additional.fuse.repos");
    private static final String userHome = System.getProperty("user.home");
    private static final String projectVersion = System.getProperty("project.version");
    private static final String mvnRepoLocal;
    private static final String mvnLocalSettings;

    public static void setUpFuse(String appServer) throws IOException {
        if (!initiated) {
            switch (appServer) {
                case "app-server-fuse7x": {
                    FuseUtils.setUpFuse7();
                    break;
                }
                case "app-server-fuse63": {
                    FuseUtils.setUpFuse6();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(appServer + " is not supported!");
                }
            }
            initiated = true;
        }
    }

    private static void setUpFuse7() throws IOException {
        log.debug((Object)"Going to set up fuse server");
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.ops4j.pax.url.mvn; config:property-set org.ops4j.pax.url.mvn.localRepository " + mvnRepoLocal + "; config:property-set org.ops4j.pax.url.mvn.settings " + mvnLocalSettings + "; config:property-append org.ops4j.pax.url.mvn.repositories  " + additionalFuseRepos + "; config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit jmx.acl.org.apache.karaf.security.jmx; config:property-append list* viewer; config:property-append set* jmxAdmin; config:property-append * jmxAdmin,admin; config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.apache.karaf.management; config:property-set jmxRealm keycloak;config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "feature:repo-add mvn:org.keycloak/keycloak-osgi-features/" + projectVersion + "/xml/features; feature:repo-add mvn:org.keycloak.testsuite/fuse-example-keycloak-features/" + projectVersion + "/xml/features; feature:install pax-http-undertow; feature:install keycloak-jaas keycloak-pax-http-undertow; feature:install keycloak-fuse-7.0-example", Result.OK);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit --factory --alias cxf org.ops4j.pax.web.context; config:property-set bundle.symbolicName org.apache.cxf.cxf-rt-transports-http; config:property-set context.id default; config:property-set context.param.keycloak.config.resolver org.keycloak.adapters.osgi.HierarchicalPathBasedKeycloakConfigResolver; config:property-set login.config.authMethod KEYCLOAK; config:property-set security.cxf.url /cxf/customerservice/*; config:property-set security.cxf.roles \"admin, user\"; config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "system:property -p hawtio.keycloakEnabled true; system:property -p hawtio.realm keycloak; system:property -p hawtio.keycloakClientConfig ${karaf.etc}/keycloak-hawtio-client.json; system:property -p hawtio.keycloakServerConfig ${karaf.etc}/keycloak-bearer.json; system:property -p hawtio.roles admin,manager,viewer,ssh; system:property -p hawtio.rolePrincipalClasses org.keycloak.adapters.jaas.RolePrincipal,org.apache.karaf.jaas.boot.principal.RolePrincipal;", Result.EMPTY);
        boolean isOSGiBundleAvailable = FuseUtils.checkCommand(managementUser, managementPassword, "bundle:id io.hawt.hawtio-osgi", Result.OK);
        FuseUtils.assertCommand(managementUser, managementPassword, isOSGiBundleAvailable ? "restart io.hawt.hawtio-osgi" : "restart io.hawt.hawtio-war", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.apache.karaf.shell; config:property-set sshRealm keycloak; config:update", Result.EMPTY);
        log.debug((Object)"Fuse server should be ready");
    }

    private static void setUpFuse6() throws IOException {
        log.debug((Object)"Going to set up fuse server");
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.ops4j.pax.url.mvn; config:propset org.ops4j.pax.url.mvn.localRepository " + mvnRepoLocal + "; config:propset org.ops4j.pax.url.mvn.settings " + mvnLocalSettings + "; config:propappend org.ops4j.pax.url.mvn.repositories  " + additionalFuseRepos + "; config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit jmx.acl.org.apache.karaf.security.jmx; config:propappend list* viewer; config:propappend set* jmxAdmin; config:propappend * jmxAdmin,admin; config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.apache.karaf.management; config:propset jmxRealm keycloak;config:update", Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "features:addurl mvn:org.keycloak/keycloak-osgi-features/" + projectVersion + "/xml/features; features:addurl mvn:org.keycloak.testsuite/fuse-example-keycloak-features/" + projectVersion + "/xml/features; features:install keycloak-fuse-6.3-example", Result.OK);
        String appServerHome = System.getProperty("app.server.home");
        Validate.notNullOrEmpty((String)appServerHome, (String)"app.server.home is not set.");
        FuseUtils.assertCommand(managementUser, managementPassword, "system-property -p hawtio.roles admin,user; system-property -p hawtio.keycloakEnabled true; system-property -p hawtio.realm keycloak; system-property -p hawtio.keycloakClientConfig file://" + appServerHome + "/etc/keycloak-hawtio-client.json; system-property -p hawtio.rolePrincipalClasses org.keycloak.adapters.jaas.RolePrincipal,org.apache.karaf.jaas.boot.principal.RolePrincipal; ", Result.EMPTY);
        String output = FuseUtils.getCommandOutput(managementUser, managementPassword, "osgi:list | grep hawtio | grep web;");
        MatcherAssert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"hawtio"));
        String id = output.substring(output.indexOf("[") + 1, output.indexOf("]")).trim();
        log.debug((Object)("osgi hawtio-web id: " + id));
        FuseUtils.assertCommand(managementUser, managementPassword, "osgi:restart " + id, Result.EMPTY);
        FuseUtils.assertCommand(managementUser, managementPassword, "config:edit org.apache.karaf.shell; config:propset sshRealm keycloak; config:update", Result.EMPTY);
        log.debug((Object)"Fuse server should be ready");
    }

    public static boolean checkCommand(String user, String password, String command, Result result) throws IOException {
        String output = FuseUtils.getCommandOutput(user, password, command);
        log.debug((Object)("Check command: " + command + ", user: " + user + ", password: " + password + ", output: " + output));
        return FuseUtils.resultToMatcher(result).matches((Object)output);
    }

    public static String assertCommand(String user, String password, String command, Result result) throws IOException {
        String output = FuseUtils.getCommandOutput(user, password, command);
        log.debug((Object)("Assert command: " + command + ", user: " + user + ", password: " + password + ", output: " + output));
        MatcherAssert.assertThat((Object)output, FuseUtils.resultToMatcher(result));
        return output;
    }

    /*
     * Exception decompiling
     */
    public static String getCommandOutput(String user, String password, String command) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ClientSession openSshChannel(String username, String password) throws IOException {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        ConnectFuture future = client.connect(username, "localhost", 8101);
        future.await();
        ClientSession session = future.getSession();
        Set<Object> ret = EnumSet.of(ClientSession.ClientSessionEvent.WAIT_AUTH);
        while (ret.contains(ClientSession.ClientSessionEvent.WAIT_AUTH)) {
            session.addPasswordIdentity(password);
            session.auth().verify();
            ret = session.waitFor(EnumSet.of(ClientSession.ClientSessionEvent.WAIT_AUTH, ClientSession.ClientSessionEvent.CLOSED, ClientSession.ClientSessionEvent.AUTHED), 0L);
        }
        if (ret.contains(ClientSession.ClientSessionEvent.CLOSED)) {
            throw new RuntimeException("Could not open SSH channel");
        }
        return session;
    }

    private static Matcher<String> resultToMatcher(Result result) {
        switch (result) {
            case EMPTY: {
                return Matchers.isEmptyString();
            }
            case OK: {
                return Matchers.not((Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Insufficient credentials"), (Matcher)Matchers.containsString((String)"Command not found"), (Matcher)Matchers.containsString((String)"Error executing command"), (Matcher)Matchers.containsString((String)"Authentication failed")));
            }
            case NOT_FOUND: {
                return Matchers.containsString((String)"Command not found");
            }
            case NO_CREDENTIALS: {
                return Matchers.containsString((String)"Insufficient credentials");
            }
            case NO_ROLES: {
                return Matchers.containsString((String)"Current user has no associated roles");
            }
        }
        Assert.fail((String)("Unexpected enum value: " + (Object)((Object)result)));
        return Matchers.containsString((String)("Unexpected enum value: " + (Object)((Object)result)));
    }

    static {
        Validate.notNullOrEmpty((String)managementUser, (String)"app.server.management.user is not set.");
        Validate.notNullOrEmpty((String)managementPassword, (String)"app.server.management.password is not set.");
        Validate.notNullOrEmpty((String)additionalFuseRepos, (String)"additional.fuse.repos is not set.");
        mvnRepoLocal = System.getProperty("maven.repo.local", userHome + "/.m2/repository");
        mvnLocalSettings = System.getProperty("maven.local.settings", userHome + "/.m2/settings.xml");
    }

    public static enum Result {
        OK,
        NOT_FOUND,
        NO_CREDENTIALS,
        NO_ROLES,
        EMPTY;

    }
}

