/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.arquillian.fuse;

import org.jboss.arquillian.container.osgi.OSGiApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;

public class KeycloakOSGiApplicationArchiveProcessor
extends OSGiApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(KeycloakOSGiApplicationArchiveProcessor.class);

    public void process(Archive<?> appArchive, TestClass testClass) {
        Class clazz = testClass.getJavaClass();
        boolean isExampleAdapterTest = KeycloakOSGiApplicationArchiveProcessor.isExampleAdapterTest(clazz);
        if (isExampleAdapterTest) {
            log.infof("Ignore OSGiApplicationArchiveProcessor for test %s", (Object)clazz.getName());
        } else {
            super.process(appArchive, testClass);
        }
    }

    public static boolean isExampleAdapterTest(Class<?> clazz) {
        Class<?> parent = clazz;
        do {
            if ((parent = parent.getSuperclass()) != null) continue;
            return false;
        } while (!parent.getName().equals("org.keycloak.testsuite.adapter.AbstractExampleAdapterTest"));
        return true;
    }
}

