/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.arquillian.fuse;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.arquillian.container.osgi.jmx.JMXDeployableContainer;
import org.jboss.arquillian.container.osgi.jmx.ObjectNameFactory;
import org.jboss.arquillian.container.osgi.karaf.managed.KarafManagedContainerConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.logging.Logger;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

public class CustomFuseContainer<T extends KarafManagedContainerConfiguration>
extends JMXDeployableContainer<T> {
    private static final Logger log = Logger.getLogger(CustomFuseContainer.class);
    private KarafManagedContainerConfiguration config;
    private Process process;

    public Class<T> getConfigurationClass() {
        Class<KarafManagedContainerConfiguration> clazz = KarafManagedContainerConfiguration.class;
        return clazz;
    }

    public void setup(T config) {
        super.setup(config);
        this.config = config;
    }

    public void start() throws LifecycleException {
        MBeanServerConnection mbeanServer = null;
        try {
            mbeanServer = this.getMBeanServerConnection(500L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (mbeanServer != null && !this.config.isAllowConnectingToRunningServer()) {
            throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
        }
        if (mbeanServer == null) {
            String karafHome = this.config.getKarafHome();
            if (karafHome == null) {
                throw new IllegalStateException("karafHome cannot be null");
            }
            File karafHomeDir = new File(karafHome).getAbsoluteFile();
            if (!karafHomeDir.isDirectory()) {
                throw new IllegalStateException("Not a valid Karaf home dir: " + karafHomeDir);
            }
            String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            log.infof("Using java: %s", (Object)java);
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java);
            String javaArgs = this.config.getJavaVmArguments();
            if (!javaArgs.contains("-Xmx")) {
                javaArgs = "-Xmx512m " + javaArgs;
            }
            cmd.addAll(Arrays.asList(javaArgs.split("\\s")));
            cmd.add("-Dkaraf.home=" + karafHomeDir);
            cmd.add("-Dkaraf.base=" + karafHomeDir);
            cmd.add("-Dkaraf.etc=" + karafHomeDir + "/etc");
            cmd.add("-Dkaraf.data=" + karafHomeDir + "/data");
            cmd.add("-Dkaraf.instances=" + karafHomeDir + "/instances");
            cmd.add("-Dkaraf.restart.jvm.supported=true");
            cmd.add("-Dkaraf.startLocalConsole=false");
            cmd.add("-Dkaraf.startRemoteShell=true");
            cmd.add("-Djava.io.tmpdir=" + new File(karafHomeDir, "data/tmp"));
            cmd.add("-Djava.util.logging.config.file=" + new File(karafHomeDir, "etc/java.util.logging.properties"));
            cmd.add("-Djava.endorsed.dirs=" + new File(karafHomeDir, "lib/endorsed"));
            StringBuilder classPath = new StringBuilder();
            boolean fuse7 = new File(karafHomeDir, "lib/boot/").exists();
            if (fuse7) {
                String[] libDirs;
                log.info((Object)"Adding karaf4 libraries to classpath.");
                for (String libDir : libDirs = new String[]{"lib/boot/", "lib/ext/"}) {
                    String[] libs;
                    File karafLibBootDir = new File(karafHomeDir, libDir);
                    for (String lib : libs = karafLibBootDir.list((dir, name) -> name.endsWith(".jar"))) {
                        String separator = classPath.length() > 0 ? File.pathSeparator : "";
                        classPath.append(separator).append(new File(karafLibBootDir, lib));
                    }
                }
            } else {
                log.info((Object)"Adding karaf3 libraries to classpath.");
                File karafLibDir = new File(karafHomeDir, "lib");
                String[] libs = karafLibDir.list((dir, name) -> name.startsWith("karaf"));
                for (String lib : libs) {
                    String separator = classPath.length() > 0 ? File.pathSeparator : "";
                    classPath.append(separator).append(new File(karafHomeDir, "lib/" + lib));
                }
            }
            cmd.add("-classpath");
            cmd.add(classPath.toString());
            cmd.add("org.apache.karaf.main.Main");
            StringBuffer cmdstr = new StringBuffer();
            for (String tok : cmd) {
                cmdstr.append(tok).append(" ");
            }
            log.debugv("Starting Karaf with: {0}", (Object)cmdstr);
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.directory(karafHomeDir);
                processBuilder.redirectErrorStream(true);
                this.process = processBuilder.start();
                new Thread(new ConsoleConsumer()).start();
            }
            catch (IOException ex) {
                throw new LifecycleException("Cannot start managed Karaf container", (Throwable)ex);
            }
            try {
                log.debug((Object)"Geting the MBeanServerConnection");
                mbeanServer = this.getMBeanServerConnection(120L, TimeUnit.SECONDS);
            }
            catch (TimeoutException ex) {
                this.destroyKarafProcess();
                throw new LifecycleException("Cannot obtain MBean server connection", (Throwable)ex);
            }
        }
        this.mbeanServerInstance.set((Object)mbeanServer);
        try {
            ObjectName oname = ObjectNameFactory.create((String)"osgi.core:type=framework,*");
            this.frameworkMBean = (FrameworkMBean)this.getMBeanProxy(mbeanServer, oname, FrameworkMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create((String)"osgi.core:type=bundleState,*");
            this.bundleStateMBean = (BundleStateMBean)this.getMBeanProxy(mbeanServer, oname, BundleStateMBean.class, 30L, TimeUnit.SECONDS);
            oname = ObjectNameFactory.create((String)"osgi.core:type=serviceState,*");
            this.serviceStateMBean = (ServiceStateMBean)this.getMBeanProxy(mbeanServer, oname, ServiceStateMBean.class, 30L, TimeUnit.SECONDS);
            this.installArquillianBundle();
            this.awaitArquillianBundleActive(30L, TimeUnit.SECONDS);
            Integer beginningStartLevel = this.config.getKarafBeginningStartLevel();
            if (beginningStartLevel != null) {
                this.awaitBeginningStartLevel(beginningStartLevel, 30L, TimeUnit.SECONDS);
            }
            this.awaitBootstrapCompleteServices();
        }
        catch (RuntimeException rte) {
            this.destroyKarafProcess();
            throw rte;
        }
        catch (IOException | InterruptedException | TimeoutException | LifecycleException ex) {
            this.destroyKarafProcess();
            throw new LifecycleException("Cannot start Karaf container", ex);
        }
    }

    public void stop() throws LifecycleException {
        try {
            super.stop();
        }
        catch (LifecycleException ex) {
            log.info((Object)"Couldn't uninstall arquillian bundle. This should be non-blocking issue, proceeding with destroying karaf process.");
        }
        this.destroyKarafProcess();
    }

    private void destroyKarafProcess() throws LifecycleException {
        if (this.process != null) {
            this.process.destroy();
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                throw new LifecycleException("Cannot start Karaf container", (Throwable)e);
            }
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = CustomFuseContainer.this.process.getInputStream();
            boolean writeOutput = CustomFuseContainer.this.config.isOutputToConsole();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

