/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.undertow;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;

public class UndertowWarClassLoader
extends ClassLoader {
    private final Archive<?> archive;

    public UndertowWarClassLoader(ClassLoader parent, Archive<?> archive) {
        super(parent);
        this.archive = archive;
    }

    @Override
    protected Class<?> findClass(String name) {
        Class<?> clazz;
        block8: {
            InputStream resourceAsStream = this.getResourceAsStream(name.replace('.', '/') + ".class");
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)resourceAsStream);
                clazz = this.defineClass(name, bytes, 0, bytes.length);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to find class [" + name + "]", e);
                }
            }
            resourceAsStream.close();
        }
        return clazz;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        if (is == null) {
            Node node;
            String resourcePath = "/WEB-INF/classes";
            if (!name.startsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            if ((node = this.archive.get(resourcePath = resourcePath + name)) == null) {
                return null;
            }
            return node.getAsset().openStream();
        }
        return is;
    }
}

