/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.utils.arquillian.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.keycloak.testsuite.utils.arquillian.DeploymentArchiveProcessorUtils;
import org.keycloak.testsuite.utils.io.IOUtil;
import org.w3c.dom.Document;

public class TomcatDeploymentArchiveProcessorUtils {
    private static final String WAR_CLASSPATH = "/WEB-INF/classes/";
    private static final String CONTEXT_PATH = "/META-INF/context.xml";
    private static final String OIDC_VALVE_CLASS = "org.keycloak.adapters.tomcat.KeycloakAuthenticatorValve";
    private static final String SAML_VALVE_CLASS = "org.keycloak.adapters.saml.tomcat.SamlAuthenticatorValve";
    private static final Logger LOG = Logger.getLogger(DeploymentArchiveProcessorUtils.class);

    public static void copyWarClasspathFilesToCommonTomcatClasspath(Archive<?> archive) {
        Stream<Node> contentOfArchiveClasspath = archive.getContent(archivePath -> archivePath.get().startsWith(WAR_CLASSPATH)).values().stream().filter(node -> StringUtils.countMatches((CharSequence)node.toString(), (CharSequence)"/") == StringUtils.countMatches((CharSequence)WAR_CLASSPATH, (CharSequence)"/") && node.toString().contains("."));
        String catalinaHome = System.getProperty("app.server.home");
        contentOfArchiveClasspath.forEach(node -> {
            java.nio.file.Path p = Paths.get(node.toString(), new String[0]);
            File outputFile = new File(catalinaHome + "/lib/" + p.getFileName().toString());
            if (!outputFile.exists()) {
                try {
                    Files.copy(node.getAsset().openStream(), outputFile.toPath(), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Couldn't copy classpath files from deployed war to common classpath of tomcat", e);
                }
            }
        });
    }

    public static void replaceKEYCLOAKMethodWithBASIC(Archive<?> archive) {
        if (!archive.contains("/WEB-INF/web.xml")) {
            return;
        }
        try {
            Document webXmlDoc = IOUtil.loadXML(archive.get("/WEB-INF/web.xml").getAsset().openStream());
            LOG.debug((Object)("Setting BASIC as auth-method in WEB.XML for " + archive.getName()));
            IOUtil.modifyDocElementValue(webXmlDoc, "auth-method", "KEYCLOAK-SAML", "BASIC");
            IOUtil.modifyDocElementValue(webXmlDoc, "auth-method", "KEYCLOAK", "BASIC");
            archive.add((Asset)new StringAsset(IOUtil.documentToString(webXmlDoc)), "/WEB-INF/web.xml");
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Error when processing " + archive.getName(), ex);
        }
    }

    public static void removeServletConfigurationInWebXML(Archive<?> archive) {
        if (!archive.contains("/WEB-INF/web.xml")) {
            return;
        }
        try {
            Document webXmlDoc = IOUtil.loadXML(archive.get("/WEB-INF/web.xml").getAsset().openStream());
            LOG.debug((Object)("Removing web.xml servlet configuration for " + archive.getName()));
            IOUtil.removeElementFromDoc(webXmlDoc, "web-app/servlet");
            IOUtil.removeElementFromDoc(webXmlDoc, "web-app/servlet-mapping");
            archive.add((Asset)new StringAsset(IOUtil.documentToString(webXmlDoc)), "/WEB-INF/web.xml");
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Error when processing " + archive.getName(), ex);
        }
    }

    public static void replaceOIDCValveWithSAMLValve(Archive<?> archive) {
        try {
            String contextXmlContent = IOUtils.toString((InputStream)archive.get(CONTEXT_PATH).getAsset().openStream(), (String)"UTF-8").replace(OIDC_VALVE_CLASS, SAML_VALVE_CLASS);
            archive.add((Asset)new StringAsset(contextXmlContent), CONTEXT_PATH);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isJaxRSApp(Archive<?> archive) {
        WebArchive webArchive = (WebArchive)archive;
        Set classes = webArchive.getContent(archivePath -> archivePath.get().startsWith(WAR_CLASSPATH) && archivePath.get().endsWith(".class")).values().stream().filter(node -> node.getAsset() instanceof ClassAsset).map(node -> ((ClassAsset)node.getAsset()).getSource()).filter(clazz -> clazz.isAnnotationPresent(Path.class)).collect(Collectors.toSet());
        return !classes.isEmpty();
    }

    public static Set<Class<?>> getApplicationConfigClasses(Archive<?> archive) {
        WebArchive webArchive = (WebArchive)archive;
        return webArchive.getContent(archivePath -> archivePath.get().startsWith(WAR_CLASSPATH) && archivePath.get().endsWith(".class")).values().stream().filter(node -> node.getAsset() instanceof ClassAsset).map(node -> ((ClassAsset)node.getAsset()).getSource()).filter(clazz -> clazz.isAnnotationPresent(ApplicationPath.class)).collect(Collectors.toSet());
    }

    public static boolean containsApplicationConfigClass(Archive<?> archive) {
        return !TomcatDeploymentArchiveProcessorUtils.getApplicationConfigClasses(archive).isEmpty();
    }
}

