/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.wellknown;

import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCWellKnownProviderFactory;
import org.keycloak.testsuite.wellknown.CustomOIDCWellKnownProvider;
import org.keycloak.wellknown.WellKnownProvider;

public class CustomOIDCWellKnownProviderFactory
extends OIDCWellKnownProviderFactory {
    public static final String INCLUDE_CLIENT_SCOPES = "oidc.wellknown.include.client.scopes";

    public WellKnownProvider create(KeycloakSession session) {
        return new CustomOIDCWellKnownProvider(session, this.getOpenidConfigOverride(), this.includeClientScopes());
    }

    private boolean includeClientScopes() {
        String includeClientScopesProp = System.getProperty(INCLUDE_CLIENT_SCOPES);
        return includeClientScopesProp == null || Boolean.parseBoolean(includeClientScopesProp);
    }

    public void init(Config.Scope config) {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CustomOIDCWellKnownProviderFactory.class.getClassLoader());
            this.initConfigOverrideFromFile("classpath:wellknown/oidc-well-known-config-override.json");
        }
        finally {
            Thread.currentThread().setContextClassLoader(orig);
        }
    }

    public String getId() {
        return "custom-testsuite-oidc-well-known-factory";
    }

    public String getAlias() {
        return "openid-configuration";
    }

    public int getPriority() {
        return 1;
    }
}

