/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordUserCredentialModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapperFactory;

public class LDAPTestUtils {
    public static UserModel addLocalUser(KeycloakSession session, RealmModel realm, String username, String email, String password) {
        UserModel user = session.userLocalStorage().addUser(realm, username);
        user.setEmail(email);
        user.setEnabled(true);
        PasswordUserCredentialModel creds = UserCredentialModel.password((String)password);
        session.userCredentialManager().updateCredential(realm, user, (CredentialInput)creds);
        return user;
    }

    public static void addLdapUser(KeycloakSession session, RealmModel appRealm, LDAPStorageProvider ldapFedProvider, String username, String password, Consumer<UserModel> userCustomizer) {
        UserModel user = ldapFedProvider.addUser(appRealm, username);
        userCustomizer.accept(user);
        if (password == null) {
            return;
        }
        session.userCredentialManager().updateCredential(appRealm, user, (CredentialInput)UserCredentialModel.password((String)username));
    }

    public static LDAPObject addLDAPUser(LDAPStorageProvider ldapProvider, RealmModel realm, final String username, final String firstName, final String lastName, final String email, final String street, final String ... postalCode) {
        UserModelDelegate helperUser = new UserModelDelegate(null){

            public String getUsername() {
                return username;
            }

            public String getEmail() {
                return email;
            }

            public String getFirstName() {
                return firstName;
            }

            public String getLastName() {
                return lastName;
            }

            public String getFirstAttribute(String name) {
                if ("lastName".equals(name)) {
                    return lastName;
                }
                if ("firstName".equals(name)) {
                    return firstName;
                }
                if ("email".equals(name)) {
                    return email;
                }
                if ("username".equals(name)) {
                    return username;
                }
                return super.getFirstAttribute(name);
            }

            public Stream<String> getAttributeStream(String name) {
                if ("lastName".equals(name)) {
                    return Stream.of(lastName);
                }
                if ("firstName".equals(name)) {
                    return Stream.of(firstName);
                }
                if ("email".equals(name)) {
                    return Stream.of(email);
                }
                if ("username".equals(name)) {
                    return Stream.of(username);
                }
                if ("postal_code".equals(name) && postalCode != null && postalCode.length > 0) {
                    return Stream.of(postalCode);
                }
                if ("street".equals(name) && street != null) {
                    return Stream.of(street);
                }
                return Stream.empty();
            }
        };
        return LDAPUtils.addUserToLDAP((LDAPStorageProvider)ldapProvider, (RealmModel)realm, (UserModel)helperUser);
    }

    public static LDAPObject addLdapOU(LDAPStorageProvider ldapProvider, String name) {
        LDAPObject ldapObject = new LDAPObject();
        ldapObject.setRdnAttributeName("ou");
        ldapObject.setObjectClasses(Collections.singletonList("organizationalUnit"));
        ldapObject.setSingleAttribute("ou", name);
        LDAPDn dn = LDAPDn.fromString((String)ldapProvider.getLdapIdentityStore().getConfig().getUsersDn());
        dn.addFirst("ou", name);
        ldapObject.setDn(dn);
        ldapProvider.getLdapIdentityStore().add(ldapObject);
        return ldapObject;
    }

    public static void updateLDAPPassword(LDAPStorageProvider ldapProvider, LDAPObject ldapUser, String password) {
        ldapProvider.getLdapIdentityStore().updatePassword(ldapUser, password, null);
        if (ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory()) {
            ldapUser.setSingleAttribute("userAccountControl", "512");
            ldapProvider.getLdapIdentityStore().update(ldapUser);
        }
    }

    public static ComponentModel getLdapProviderModel(RealmModel realm) {
        return realm.getComponentsStream(realm.getId(), UserStorageProvider.class.getName()).filter(component -> Objects.equals(component.getProviderId(), "ldap")).findFirst().orElse(null);
    }

    public static LDAPStorageProvider getLdapProvider(KeycloakSession keycloakSession, ComponentModel ldapFedModel) {
        return (LDAPStorageProvider)keycloakSession.getProvider(UserStorageProvider.class, ldapFedModel);
    }

    public static void addZipCodeLDAPMapper(RealmModel realm, ComponentModel providerModel) {
        LDAPTestUtils.addUserAttributeMapper(realm, providerModel, "zipCodeMapper", "postal_code", "postalCode");
    }

    public static ComponentModel addUserAttributeMapper(RealmModel realm, ComponentModel providerModel, String mapperName, String userModelAttributeName, String ldapAttributeName) {
        ComponentModel mapperModel = KeycloakModelUtils.createComponentModel((String)mapperName, (String)providerModel.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", userModelAttributeName, "ldap.attribute", ldapAttributeName, "read.only", "false", "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "false"});
        return realm.addComponentModel(mapperModel);
    }

    public static void addOrUpdateRoleLDAPMappers(RealmModel realm, ComponentModel providerModel, LDAPGroupMapperMode mode) {
        String baseDn;
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "realmRolesMapper");
        if (mapperModel != null) {
            mapperModel.getConfig().putSingle((Object)"mode", (Object)mode.toString());
            realm.updateComponent(mapperModel);
        } else {
            baseDn = (String)providerModel.getConfig().getFirst((Object)"baseDn");
            mapperModel = KeycloakModelUtils.createComponentModel((String)"realmRolesMapper", (String)providerModel.getId(), (String)"role-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"roles.dn", "ou=RealmRoles," + baseDn, "use.realm.roles.mapping", "true", "mode", mode.toString()});
            realm.addComponentModel(mapperModel);
        }
        mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "financeRolesMapper");
        if (mapperModel != null) {
            mapperModel.getConfig().putSingle((Object)"mode", (Object)mode.toString());
            realm.updateComponent(mapperModel);
        } else {
            baseDn = (String)providerModel.getConfig().getFirst((Object)"baseDn");
            mapperModel = KeycloakModelUtils.createComponentModel((String)"financeRolesMapper", (String)providerModel.getId(), (String)"role-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"roles.dn", "ou=FinanceRoles," + baseDn, "use.realm.roles.mapping", "false", "client.id", "finance", "mode", mode.toString()});
            realm.addComponentModel(mapperModel);
        }
    }

    public static ComponentModel getSubcomponentByName(RealmModel realm, ComponentModel providerModel, String name) {
        return realm.getComponentsStream(providerModel.getId(), LDAPStorageMapper.class.getName()).filter(component -> Objects.equals(name, component.getName())).findFirst().orElse(null);
    }

    public static void addOrUpdateGroupMapper(RealmModel realm, ComponentModel providerModel, LDAPGroupMapperMode mode, String descriptionAttrName, String ... otherConfigOptions) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "groupsMapper");
        if (mapperModel != null) {
            mapperModel.getConfig().putSingle((Object)"mode", (Object)mode.toString());
            LDAPTestUtils.updateGroupMapperConfigOptions(mapperModel, otherConfigOptions);
            realm.updateComponent(mapperModel);
        } else {
            String baseDn = (String)providerModel.getConfig().getFirst((Object)"baseDn");
            mapperModel = KeycloakModelUtils.createComponentModel((String)"groupsMapper", (String)providerModel.getId(), (String)"group-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"groups.dn", "ou=Groups," + baseDn, "mapped.group.attributes", descriptionAttrName, "preserve.group.inheritance", "true", "mode", mode.toString(), "groups.path", "/"});
            LDAPTestUtils.updateGroupMapperConfigOptions(mapperModel, otherConfigOptions);
            realm.addComponentModel(mapperModel);
        }
    }

    public static void addOrUpdateRoleMapper(RealmModel realm, ComponentModel providerModel, LDAPGroupMapperMode mode, String ... otherConfigOptions) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "rolesMapper");
        if (mapperModel != null) {
            mapperModel.getConfig().putSingle((Object)"mode", (Object)mode.toString());
            LDAPTestUtils.updateGroupMapperConfigOptions(mapperModel, otherConfigOptions);
            realm.updateComponent(mapperModel);
        } else {
            String baseDn = (String)providerModel.getConfig().getFirst((Object)"baseDn");
            mapperModel = KeycloakModelUtils.createComponentModel((String)"rolesMapper", (String)providerModel.getId(), (String)"role-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"roles.dn", "ou=Groups," + baseDn, "use.realm.roles.mapping", "true", "mode", mode.toString()});
            LDAPTestUtils.updateGroupMapperConfigOptions(mapperModel, otherConfigOptions);
            realm.addComponentModel(mapperModel);
        }
    }

    public static void updateGroupMapperConfigOptions(ComponentModel mapperModel, String ... configOptions) {
        for (int i = 0; i < configOptions.length; i += 2) {
            String cfgName = configOptions[i];
            String cfgValue = configOptions[i + 1];
            mapperModel.getConfig().putSingle((Object)cfgName, (Object)cfgValue);
        }
    }

    public static void syncRolesFromLDAP(RealmModel realm, LDAPStorageProvider ldapProvider, ComponentModel providerModel) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "realmRolesMapper");
        RoleLDAPStorageMapper roleMapper = LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, realm);
        roleMapper.syncDataFromFederationProviderToKeycloak(realm);
        mapperModel = LDAPTestUtils.getSubcomponentByName(realm, providerModel, "financeRolesMapper");
        roleMapper = LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, realm);
        roleMapper.syncDataFromFederationProviderToKeycloak(realm);
    }

    public static void removeAllLDAPUsers(LDAPStorageProvider ldapProvider, RealmModel realm) {
        LDAPIdentityStore ldapStore = ldapProvider.getLdapIdentityStore();
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch((LDAPStorageProvider)ldapProvider, (RealmModel)realm);){
            List allUsers = ldapQuery.getResultList();
            for (LDAPObject ldapUser : allUsers) {
                ldapStore.remove(ldapUser);
            }
        }
    }

    public static void removeLDAPUserByUsername(LDAPStorageProvider ldapProvider, RealmModel realm, LDAPConfig config, String username) {
        LDAPIdentityStore ldapStore = ldapProvider.getLdapIdentityStore();
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch((LDAPStorageProvider)ldapProvider, (RealmModel)realm);){
            List allUsers = ldapQuery.getResultList();
            for (LDAPObject ldapUser : allUsers) {
                if (!username.equals(LDAPUtils.getUsername((LDAPObject)ldapUser, (LDAPConfig)config))) continue;
                ldapStore.remove(ldapUser);
            }
        }
    }

    public static void removeAllLDAPRoles(KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, String mapperName) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(appRealm, ldapModel, mapperName);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(session, ldapModel);
        try (LDAPQuery roleQuery = LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, appRealm).createRoleQuery(false);){
            List ldapRoles = roleQuery.getResultList();
            for (LDAPObject ldapRole : ldapRoles) {
                ldapProvider.getLdapIdentityStore().remove(ldapRole);
            }
        }
    }

    public static void removeAllLDAPGroups(KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, String mapperName) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(appRealm, ldapModel, mapperName);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(session, ldapModel);
        LDAPQuery query = null;
        query = "group-ldap-mapper".equals(mapperModel.getProviderId()) ? LDAPTestUtils.getGroupMapper(mapperModel, ldapProvider, appRealm).createGroupQuery(false) : LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, appRealm).createRoleQuery(false);
        try (LDAPQuery roleQuery = query;){
            List ldapRoles = roleQuery.getResultList();
            for (LDAPObject ldapRole : ldapRoles) {
                ldapProvider.getLdapIdentityStore().remove(ldapRole);
            }
        }
    }

    public static void createLDAPRole(KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, String mapperName, String roleName) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(appRealm, ldapModel, mapperName);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(session, ldapModel);
        LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, appRealm).createLDAPRole(roleName);
    }

    public static LDAPObject createLDAPGroup(KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, String groupName, String ... additionalAttrs) {
        return LDAPTestUtils.createLDAPGroup("groupsMapper", session, appRealm, ldapModel, groupName, additionalAttrs);
    }

    public static LDAPObject createLDAPGroup(String mapperName, KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, String groupName, String ... additionalAttrs) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(appRealm, ldapModel, mapperName);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(session, ldapModel);
        HashMap<String, Set<String>> additAttrs = new HashMap<String, Set<String>>();
        for (int i = 0; i < additionalAttrs.length; i += 2) {
            String attrName = additionalAttrs[i];
            String attrValue = additionalAttrs[i + 1];
            additAttrs.put(attrName, Collections.singleton(attrValue));
        }
        if ("group-ldap-mapper".equals(mapperModel.getProviderId())) {
            return LDAPTestUtils.getGroupMapper(mapperModel, ldapProvider, appRealm).createLDAPGroup(groupName, additAttrs);
        }
        return LDAPTestUtils.getRoleMapper(mapperModel, ldapProvider, appRealm).createLDAPRole(groupName);
    }

    public static LDAPObject updateLDAPGroup(KeycloakSession session, RealmModel appRealm, ComponentModel ldapModel, LDAPObject ldapObject) {
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(appRealm, ldapModel, "groupsMapper");
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(session, ldapModel);
        return LDAPTestUtils.getGroupMapper(mapperModel, ldapProvider, appRealm).updateLDAPGroup(ldapObject);
    }

    public static GroupLDAPStorageMapper getGroupMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RealmModel realm) {
        return new GroupLDAPStorageMapper(mapperModel, ldapProvider, new GroupLDAPStorageMapperFactory());
    }

    public static RoleLDAPStorageMapper getRoleMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider, RealmModel realm) {
        return new RoleLDAPStorageMapper(mapperModel, ldapProvider, new RoleLDAPStorageMapperFactory());
    }

    public static String getGroupDescriptionLDAPAttrName(LDAPStorageProvider ldapProvider) {
        return ldapProvider.getLdapIdentityStore().getConfig().isActiveDirectory() ? "displayName" : "description";
    }
}

