/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.Profile;
import org.keycloak.provider.DefaultProviderLoader;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.ProviderManagerRegistry;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSession;

public class FeatureDeployerUtil {
    private static final Map<Profile.Feature, Map<ProviderFactory, Spi>> initializer = new ConcurrentHashMap<Profile.Feature, Map<ProviderFactory, Spi>>();
    private static final Map<Profile.Feature, ProviderManager> deployersCache = new ConcurrentHashMap<Profile.Feature, ProviderManager>();
    private static final Logger logger = Logger.getLogger(FeatureDeployerUtil.class);

    public static void initBeforeChangeFeature(Profile.Feature feature) {
        if (deployersCache.containsKey(feature)) {
            return;
        }
        Map<ProviderFactory, Spi> factoriesBefore = FeatureDeployerUtil.loadEnabledEnvironmentFactories();
        initializer.put(feature, factoriesBefore);
    }

    public static void deployFactoriesAfterFeatureEnabled(Profile.Feature feature) {
        ProviderManager manager = deployersCache.get(feature);
        if (manager == null) {
            Map<ProviderFactory, Spi> factoriesBeforeEnable = initializer.remove(feature);
            Map<ProviderFactory, Spi> factoriesAfterEnable = FeatureDeployerUtil.loadEnabledEnvironmentFactories();
            Map<ProviderFactory, Spi> factories = FeatureDeployerUtil.getFactoriesDependentOnFeature(factoriesBeforeEnable, factoriesAfterEnable);
            logger.infof("New factories when enabling feature '%s': %s", (Object)feature, factories.keySet());
            KeycloakDeploymentInfo di = FeatureDeployerUtil.createDeploymentInfo(factories);
            manager = new ProviderManager(di, FeatureDeployerUtil.class.getClassLoader(), new String[0]);
            deployersCache.put(feature, manager);
        }
        ProviderManagerRegistry.SINGLETON.deploy(manager);
    }

    public static void undeployFactoriesAfterFeatureDisabled(Profile.Feature feature) {
        ProviderManager manager = deployersCache.get(feature);
        if (manager == null) {
            Map<ProviderFactory, Spi> factoriesBeforeDisable = initializer.remove(feature);
            Map<ProviderFactory, Spi> factoriesAfterDisable = FeatureDeployerUtil.loadEnabledEnvironmentFactories();
            Map<ProviderFactory, Spi> factories = FeatureDeployerUtil.getFactoriesDependentOnFeature(factoriesAfterDisable, factoriesBeforeDisable);
            KeycloakDeploymentInfo di = FeatureDeployerUtil.createDeploymentInfo(factories);
            manager = new ProviderManager(di, FeatureDeployerUtil.class.getClassLoader(), new String[0]);
            FeatureDeployerUtil.loadFactories(manager);
            deployersCache.put(feature, manager);
        }
        ProviderManagerRegistry.SINGLETON.undeploy(manager);
    }

    private static Map<ProviderFactory, Spi> getFactoriesDependentOnFeature(Map<ProviderFactory, Spi> factoriesDisabled, Map<ProviderFactory, Spi> factoriesEnabled) {
        Set disabledFactoriesClasses = factoriesDisabled.keySet().stream().map(Object::getClass).collect(Collectors.toSet());
        Set enabledFactoriesClasses = factoriesEnabled.keySet().stream().map(Object::getClass).collect(Collectors.toSet());
        enabledFactoriesClasses.removeAll(disabledFactoriesClasses);
        Map<ProviderFactory, Spi> newFactories = factoriesEnabled.entrySet().stream().filter(entry -> enabledFactoriesClasses.contains(((ProviderFactory)entry.getKey()).getClass())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return newFactories;
    }

    private static KeycloakDeploymentInfo createDeploymentInfo(Map<ProviderFactory, Spi> factories) {
        KeycloakDeploymentInfo di = KeycloakDeploymentInfo.create();
        for (Map.Entry<ProviderFactory, Spi> factory : factories.entrySet()) {
            ProviderFactory pf = factory.getKey();
            Class<?> spiClass = factory.getValue().getClass();
            di.addProvider(spiClass, pf);
        }
        return di;
    }

    private static Map<ProviderFactory, Spi> loadEnabledEnvironmentFactories() {
        KeycloakDeploymentInfo di = KeycloakDeploymentInfo.create().services();
        ClassLoader classLoader = DefaultKeycloakSession.class.getClassLoader();
        DefaultProviderLoader loader = new DefaultProviderLoader(di, classLoader);
        HashMap<ProviderFactory, Spi> providerFactories = new HashMap<ProviderFactory, Spi>();
        for (Spi spi : loader.loadSpis()) {
            List currentFactories = loader.load(spi);
            for (ProviderFactory factory : currentFactories) {
                if (!(factory instanceof EnvironmentDependentProviderFactory) || !((EnvironmentDependentProviderFactory)factory).isSupported()) continue;
                providerFactories.put(factory, spi);
            }
        }
        return providerFactories;
    }

    private static void loadFactories(ProviderManager pm) {
        KeycloakDeploymentInfo di = KeycloakDeploymentInfo.create().services();
        ClassLoader classLoader = DefaultKeycloakSession.class.getClassLoader();
        DefaultProviderLoader loader = new DefaultProviderLoader(di, classLoader);
        loader.loadSpis().forEach(arg_0 -> ((ProviderManager)pm).load(arg_0));
    }
}

