/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.JavaAlgorithm;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.MacSignatureSignerContext;
import org.keycloak.crypto.ServerECDSASignatureSignerContext;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelRequest;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.testsuite.rest.TestApplicationResourceProviderFactory;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;
import org.keycloak.util.JsonSerialization;

public class TestingOIDCEndpointsApplicationResource {
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PUBLIC_KEY = "publicKey";
    private final TestApplicationResourceProviderFactory.OIDCClientData clientData;
    private final ConcurrentMap<String, TestAuthenticationChannelRequest> authenticationChannelRequests;
    private final ConcurrentMap<String, ClientNotificationEndpointRequest> cibaClientNotifications;
    private static final String ChannelRequestDummyKey = "channel_request_dummy_key";

    public TestingOIDCEndpointsApplicationResource(TestApplicationResourceProviderFactory.OIDCClientData oidcClientData, ConcurrentMap<String, TestAuthenticationChannelRequest> authenticationChannelRequests, ConcurrentMap<String, ClientNotificationEndpointRequest> cibaClientNotifications) {
        this.clientData = oidcClientData;
        this.authenticationChannelRequests = authenticationChannelRequests;
        this.cibaClientNotifications = cibaClientNotifications;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/generate-keys")
    @NoCache
    public Map<String, String> generateKeys(@QueryParam(value="jwaAlgorithm") String jwaAlgorithm, @QueryParam(value="advertiseJWKAlgorithm") Boolean advertiseJWKAlgorithm) {
        try {
            KeyPair keyPair = null;
            KeyUse keyUse = KeyUse.SIG;
            if (jwaAlgorithm == null) {
                jwaAlgorithm = "RS256";
            }
            String keyType = null;
            switch (jwaAlgorithm) {
                case "RS256": 
                case "RS384": 
                case "RS512": 
                case "PS256": 
                case "PS384": 
                case "PS512": {
                    keyType = "RSA";
                    keyPair = KeyUtils.generateRsaKeyPair((int)2048);
                    break;
                }
                case "ES256": {
                    keyType = "EC";
                    keyPair = this.generateEcdsaKey("secp256r1");
                    break;
                }
                case "ES384": {
                    keyType = "EC";
                    keyPair = this.generateEcdsaKey("secp384r1");
                    break;
                }
                case "ES512": {
                    keyType = "EC";
                    keyPair = this.generateEcdsaKey("secp521r1");
                    break;
                }
                case "RSA1_5": 
                case "RSA-OAEP": 
                case "RSA-OAEP-256": {
                    keyType = "RSA";
                    keyUse = KeyUse.ENC;
                    keyPair = KeyUtils.generateRsaKeyPair((int)2048);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported signature algorithm");
                }
            }
            this.clientData.setKeyPair(keyPair);
            this.clientData.setKeyType(keyType);
            if (advertiseJWKAlgorithm == null || Boolean.TRUE.equals(advertiseJWKAlgorithm)) {
                this.clientData.setKeyAlgorithm(jwaAlgorithm);
            } else {
                this.clientData.setKeyAlgorithm(null);
            }
            this.clientData.setKeyUse(keyUse);
        }
        catch (Exception e) {
            throw new BadRequestException("Error generating signing keypair", (Throwable)e);
        }
        return this.getKeysAsPem();
    }

    private KeyPair generateEcdsaKey(String ecDomainParamName) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
        SecureRandom randomGen = SecureRandom.getInstance("SHA1PRNG");
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(ecDomainParamName);
        keyGen.initialize(ecSpec, randomGen);
        KeyPair keyPair = keyGen.generateKeyPair();
        return keyPair;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-keys-as-pem")
    public Map<String, String> getKeysAsPem() {
        String privateKeyPem = PemUtils.encodeKey((Key)this.clientData.getSigningKeyPair().getPrivate());
        String publicKeyPem = PemUtils.encodeKey((Key)this.clientData.getSigningKeyPair().getPublic());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(PRIVATE_KEY, privateKeyPem);
        res.put(PUBLIC_KEY, publicKeyPem);
        return res;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-keys-as-base64")
    public Map<String, String> getKeysAsBase64() {
        String privateKeyPem = Base64.encodeBytes((byte[])this.clientData.getSigningKeyPair().getPrivate().getEncoded());
        String publicKeyPem = Base64.encodeBytes((byte[])this.clientData.getSigningKeyPair().getPublic().getEncoded());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put(PRIVATE_KEY, privateKeyPem);
        res.put(PUBLIC_KEY, publicKeyPem);
        return res;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/get-jwks")
    @NoCache
    public JSONWebKeySet getJwks() {
        JSONWebKeySet keySet = new JSONWebKeySet();
        KeyPair keyPair = this.clientData.getKeyPair();
        String keyAlgorithm = this.clientData.getKeyAlgorithm();
        String keyType = this.clientData.getKeyType();
        KeyUse keyUse = this.clientData.getKeyUse();
        if (keyPair == null) {
            keySet.setKeys(new JWK[0]);
        } else if ("RSA".equals(keyType)) {
            keySet.setKeys(new JWK[]{JWKBuilder.create().algorithm(keyAlgorithm).rsa((Key)keyPair.getPublic(), keyUse)});
        } else if ("EC".equals(keyType)) {
            keySet.setKeys(new JWK[]{JWKBuilder.create().algorithm(keyAlgorithm).ec((Key)keyPair.getPublic())});
        } else {
            keySet.setKeys(new JWK[0]);
        }
        return keySet;
    }

    @GET
    @Path(value="/set-oidc-request")
    @Produces(value={"application/jwt"})
    @NoCache
    public void setOIDCRequest(@QueryParam(value="realmName") String realmName, @QueryParam(value="clientId") String clientId, @QueryParam(value="redirectUri") String redirectUri, @QueryParam(value="maxAge") String maxAge, @QueryParam(value="state") String state, @QueryParam(value="jwaAlgorithm") String jwaAlgorithm) {
        HashMap<String, Object> oidcRequest = new HashMap<String, Object>();
        oidcRequest.put("client_id", clientId);
        oidcRequest.put("response_type", "code");
        oidcRequest.put("redirect_uri", redirectUri);
        if (state != null) {
            oidcRequest.put("state", state);
        }
        if (maxAge != null) {
            oidcRequest.put("max_age", Integer.parseInt(maxAge));
        }
        this.setOidcRequest(oidcRequest, jwaAlgorithm);
    }

    @GET
    @Path(value="/register-oidc-request")
    @Produces(value={"application/jwt"})
    @NoCache
    public void registerOIDCRequest(@QueryParam(value="requestObject") String encodedRequestObject, @QueryParam(value="jwaAlgorithm") String jwaAlgorithm) {
        AuthorizationEndpointRequestObject oidcRequest = this.deserializeOidcRequest(encodedRequestObject);
        this.setOidcRequest((Object)oidcRequest, jwaAlgorithm);
    }

    @GET
    @Path(value="/register-oidc-request-symmetric-sig")
    @Produces(value={"application/jwt"})
    @NoCache
    public void registerOIDCRequestSymmetricSig(@QueryParam(value="requestObject") String encodedRequestObject, @QueryParam(value="jwaAlgorithm") String jwaAlgorithm, @QueryParam(value="clientSecret") String clientSecret) {
        AuthorizationEndpointRequestObject oidcRequest = this.deserializeOidcRequest(encodedRequestObject);
        this.setOidcRequest((Object)oidcRequest, jwaAlgorithm, clientSecret);
    }

    private AuthorizationEndpointRequestObject deserializeOidcRequest(String encodedRequestObject) {
        byte[] serializedRequestObject = Base64Url.decode((String)encodedRequestObject);
        AuthorizationEndpointRequestObject oidcRequest = null;
        try {
            oidcRequest = (AuthorizationEndpointRequestObject)((Object)JsonSerialization.readValue((byte[])serializedRequestObject, AuthorizationEndpointRequestObject.class));
        }
        catch (IOException e) {
            throw new BadRequestException("deserialize request object failed : " + e.getMessage());
        }
        return oidcRequest;
    }

    private void setOidcRequest(Object oidcRequest, String jwaAlgorithm) {
        if (!this.isSupportedAlgorithm(jwaAlgorithm)) {
            throw new BadRequestException("Unknown argument: " + jwaAlgorithm);
        }
        if ("none".equals(jwaAlgorithm)) {
            this.clientData.setOidcRequest(new JWSBuilder().jsonContent(oidcRequest).none());
        } else {
            ServerECDSASignatureSignerContext signer;
            if (this.clientData.getSigningKeyPair() == null) {
                throw new BadRequestException("signing key not set");
            }
            PrivateKey privateKey = this.clientData.getSigningKeyPair().getPrivate();
            String kid = KeyUtils.createKeyId((Key)this.clientData.getSigningKeyPair().getPublic());
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setAlgorithm(this.clientData.getSigningKeyAlgorithm());
            keyWrapper.setKid(kid);
            keyWrapper.setPrivateKey((Key)privateKey);
            switch (this.clientData.getSigningKeyAlgorithm()) {
                case "ES256": 
                case "ES384": 
                case "ES512": {
                    signer = new ServerECDSASignatureSignerContext(keyWrapper);
                    break;
                }
                default: {
                    signer = new AsymmetricSignatureSignerContext(keyWrapper);
                }
            }
            this.clientData.setOidcRequest(new JWSBuilder().kid(kid).jsonContent(oidcRequest).sign((SignatureSignerContext)signer));
        }
    }

    private void setOidcRequest(Object oidcRequest, String jwaAlgorithm, String clientSecret) {
        if (!this.isSupportedAlgorithm(jwaAlgorithm)) {
            throw new BadRequestException("Unknown argument: " + jwaAlgorithm);
        }
        if ("none".equals(jwaAlgorithm)) {
            this.clientData.setOidcRequest(new JWSBuilder().jsonContent(oidcRequest).none());
        } else {
            switch (jwaAlgorithm) {
                case "HS256": 
                case "HS384": 
                case "HS512": {
                    KeyWrapper keyWrapper = new KeyWrapper();
                    SecretKeySpec secretKey = new SecretKeySpec(clientSecret.getBytes(StandardCharsets.UTF_8), JavaAlgorithm.getJavaAlgorithm((String)jwaAlgorithm));
                    keyWrapper.setSecretKey((SecretKey)secretKey);
                    String kid = KeyUtils.createKeyId((Key)secretKey);
                    keyWrapper.setKid(kid);
                    keyWrapper.setAlgorithm(jwaAlgorithm);
                    keyWrapper.setUse(KeyUse.SIG);
                    keyWrapper.setType("OCT");
                    MacSignatureSignerContext signer = new MacSignatureSignerContext(keyWrapper);
                    this.clientData.setOidcRequest(new JWSBuilder().kid(kid).jsonContent(oidcRequest).sign((SignatureSignerContext)signer));
                    break;
                }
                default: {
                    throw new BadRequestException("Unknown jwaAlgorithm: " + jwaAlgorithm);
                }
            }
        }
    }

    private boolean isSupportedAlgorithm(String signingAlgorithm) {
        if (signingAlgorithm == null) {
            return false;
        }
        boolean ret = false;
        switch (signingAlgorithm) {
            case "none": 
            case "RS256": 
            case "RS384": 
            case "RS512": 
            case "PS256": 
            case "PS384": 
            case "PS512": 
            case "ES256": 
            case "ES384": 
            case "ES512": 
            case "HS256": 
            case "HS384": 
            case "HS512": 
            case "RSA1_5": 
            case "RSA-OAEP": 
            case "RSA-OAEP-256": {
                ret = true;
            }
        }
        return ret;
    }

    @GET
    @Path(value="/get-oidc-request")
    @Produces(value={"application/jwt"})
    @NoCache
    public String getOIDCRequest() {
        return this.clientData.getOidcRequest();
    }

    @GET
    @Path(value="/set-sector-identifier-redirect-uris")
    @Produces(value={"application/json"})
    public void setSectorIdentifierRedirectUris(@QueryParam(value="redirectUris") List<String> redirectUris) {
        this.clientData.setSectorIdentifierRedirectUris(new ArrayList<String>());
        this.clientData.getSectorIdentifierRedirectUris().addAll(redirectUris);
    }

    @GET
    @Path(value="/get-sector-identifier-redirect-uris")
    @Produces(value={"application/json"})
    public List<String> getSectorIdentifierRedirectUris() {
        return this.clientData.getSectorIdentifierRedirectUris();
    }

    @POST
    @Path(value="/request-authentication-channel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response requestAuthenticationChannel(@Context HttpHeaders headers, AuthenticationChannelRequest request) {
        AccessToken bearerToken;
        String rawBearerToken = AppAuthManager.extractAuthorizationHeaderToken((HttpHeaders)headers);
        try {
            bearerToken = (AccessToken)new JWSInput(rawBearerToken).readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new RuntimeException("Failed to parse bearer token", e);
        }
        String authenticationChannelId = bearerToken.getId();
        if (authenticationChannelId == null) {
            throw new BadRequestException("missing parameter : authentication_channel_id");
        }
        String loginHint = request.getLoginHint();
        if (loginHint == null) {
            throw new BadRequestException("missing parameter : login_hint");
        }
        if (request.getConsentRequired() == null) {
            throw new BadRequestException("missing parameter : is_consent_required");
        }
        String scope = request.getScope();
        if (scope == null) {
            throw new BadRequestException("missing parameter : scope");
        }
        String bindingMessage = request.getBindingMessage();
        if (bindingMessage != null && bindingMessage.equals("GODOWN")) {
            throw new BadRequestException("intentional error : GODOWN");
        }
        if (bindingMessage == null) {
            bindingMessage = ChannelRequestDummyKey;
        }
        this.authenticationChannelRequests.put(bindingMessage, new TestAuthenticationChannelRequest(request, rawBearerToken));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/get-authentication-channel")
    @Produces(value={"application/json"})
    @NoCache
    public TestAuthenticationChannelRequest getAuthenticationChannel(@QueryParam(value="bindingMessage") String bindingMessage) {
        if (bindingMessage == null) {
            bindingMessage = ChannelRequestDummyKey;
        }
        return (TestAuthenticationChannelRequest)this.authenticationChannelRequests.get(bindingMessage);
    }

    @POST
    @Path(value="/push-ciba-client-notification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response cibaClientNotificationEndpoint(@Context HttpHeaders headers, ClientNotificationEndpointRequest request) {
        String clientNotificationToken = AppAuthManager.extractAuthorizationHeaderToken((HttpHeaders)headers);
        ClientNotificationEndpointRequest existing = this.cibaClientNotifications.putIfAbsent(clientNotificationToken, request);
        if (existing != null) {
            throw new ErrorResponseException("invalid_request", "There is already entry for clientNotification " + clientNotificationToken + ". Make sure to cleanup after previous tests.", Response.Status.BAD_REQUEST);
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/get-pushed-ciba-client-notification")
    @Produces(value={"application/json"})
    @NoCache
    public ClientNotificationEndpointRequest getPushedCibaClientNotification(@QueryParam(value="clientNotificationToken") String clientNotificationToken) {
        ClientNotificationEndpointRequest request = (ClientNotificationEndpointRequest)this.cibaClientNotifications.remove(clientNotificationToken);
        if (request == null) {
            request = new ClientNotificationEndpointRequest();
        }
        return request;
    }

    public static class AuthorizationEndpointRequestObject
    extends JsonWebToken {
        @JsonProperty(value="client_id")
        String clientId;
        @JsonProperty(value="response_type")
        String responseType;
        @JsonProperty(value="response_mode")
        String responseMode;
        @JsonProperty(value="redirect_uri")
        String redirectUriParam;
        @JsonProperty(value="state")
        String state;
        @JsonProperty(value="scope")
        String scope;
        @JsonProperty(value="login_hint")
        String loginHint;
        @JsonProperty(value="prompt")
        String prompt;
        @JsonProperty(value="nonce")
        String nonce;
        Integer max_age;
        @JsonProperty(value="ui_locales")
        String uiLocales;
        @JsonProperty(value="acr_values")
        String acr;
        @JsonProperty(value="display")
        String display;
        @JsonProperty(value="code_challenge")
        String codeChallenge;
        @JsonProperty(value="code_challenge_method")
        String codeChallengeMethod;
        @JsonProperty(value="kc_idp_hint")
        String idpHint;
        @JsonProperty(value="kc_action")
        String action;
        @JsonProperty(value="client_notification_token")
        String clientNotificationToken;
        @JsonProperty(value="login_hint_token")
        String loginHintToken;
        @JsonProperty(value="id_token_hint")
        String idTokenHint;
        @JsonProperty(value="user_code")
        String userCode;
        @JsonProperty(value="binding_message")
        String bindingMessage;
        Integer requested_expiry;

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public String getResponseMode() {
            return this.responseMode;
        }

        public void setResponseMode(String responseMode) {
            this.responseMode = responseMode;
        }

        public String getRedirectUriParam() {
            return this.redirectUriParam;
        }

        public void setRedirectUriParam(String redirectUriParam) {
            this.redirectUriParam = redirectUriParam;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getLoginHint() {
            return this.loginHint;
        }

        public void setLoginHint(String loginHint) {
            this.loginHint = loginHint;
        }

        public String getPrompt() {
            return this.prompt;
        }

        public void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public Integer getMax_age() {
            return this.max_age;
        }

        public void setMax_age(Integer max_age) {
            this.max_age = max_age;
        }

        public String getUiLocales() {
            return this.uiLocales;
        }

        public void setUiLocales(String uiLocales) {
            this.uiLocales = uiLocales;
        }

        public String getAcr() {
            return this.acr;
        }

        public void setAcr(String acr) {
            this.acr = acr;
        }

        public String getCodeChallenge() {
            return this.codeChallenge;
        }

        public void setCodeChallenge(String codeChallenge) {
            this.codeChallenge = codeChallenge;
        }

        public String getCodeChallengeMethod() {
            return this.codeChallengeMethod;
        }

        public void setCodeChallengeMethod(String codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public String getIdpHint() {
            return this.idpHint;
        }

        public void setIdpHint(String idpHint) {
            this.idpHint = idpHint;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getClientNotificationToken() {
            return this.clientNotificationToken;
        }

        public void setClientNotificationToken(String clientNotificationToken) {
            this.clientNotificationToken = clientNotificationToken;
        }

        public String getLoginHintToken() {
            return this.loginHintToken;
        }

        public void setLoginHintToken(String loginHintToken) {
            this.loginHintToken = loginHintToken;
        }

        public String getIdTokenHint() {
            return this.idTokenHint;
        }

        public void setIdTokenHint(String idTokenHint) {
            this.idTokenHint = idTokenHint;
        }

        public String getBindingMessage() {
            return this.bindingMessage;
        }

        public void setBindingMessage(String bindingMessage) {
            this.bindingMessage = bindingMessage;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public void setUserCode(String userCode) {
            this.userCode = userCode;
        }

        public Integer getRequested_expiry() {
            return this.requested_expiry;
        }

        public void setRequested_expiry(Integer requested_expiry) {
            this.requested_expiry = requested_expiry;
        }
    }
}

