/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest.resource;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.KeycloakSession;

public class TestingExportImportResource {
    private final KeycloakSession session;
    private static String tempDir;

    public TestingExportImportResource(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="/run-import")
    @Produces(value={"application/json"})
    public Response runImport() {
        new ExportImportManager(this.session).runImport();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/run-export")
    @Produces(value={"application/json"})
    public Response runExport() {
        new ExportImportManager(this.session).runExport();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/get-users-per-file")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Integer getUsersPerFile() {
        String usersPerFile = System.getProperty("keycloak.migration.usersPerFile", String.valueOf(ExportImportConfig.DEFAULT_USERS_PER_FILE));
        return Integer.parseInt(usersPerFile.trim());
    }

    @PUT
    @Path(value="/set-users-per-file")
    @Consumes(value={"application/json"})
    public void setUsersPerFile(@QueryParam(value="usersPerFile") Integer usersPerFile) {
        System.setProperty("keycloak.migration.usersPerFile", String.valueOf(usersPerFile));
    }

    @GET
    @Path(value="/get-dir")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getDir() {
        return System.getProperty("keycloak.migration.dir");
    }

    @PUT
    @Path(value="/set-dir")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String setDir(@QueryParam(value="dir") String dir) {
        return System.setProperty("keycloak.migration.dir", dir);
    }

    @PUT
    @Path(value="/set-import-strategy")
    @Consumes(value={"application/json"})
    public void setStrategy(@QueryParam(value="importStrategy") Strategy strategy) {
        System.setProperty("keycloak.migration.strategy", strategy.name());
    }

    @PUT
    @Path(value="/export-import-provider")
    @Consumes(value={"application/json"})
    public void setProvider(@QueryParam(value="exportImportProvider") String exportImportProvider) {
        System.setProperty("keycloak.migration.provider", exportImportProvider);
    }

    @PUT
    @Path(value="/export-import-file")
    @Consumes(value={"application/json"})
    public void setFile(@QueryParam(value="file") String file) {
        System.setProperty("keycloak.migration.file", file);
    }

    @PUT
    @Path(value="/export-import-action")
    @Consumes(value={"application/json"})
    public void setAction(@QueryParam(value="exportImportAction") String exportImportAction) {
        System.setProperty("keycloak.migration.action", exportImportAction);
    }

    @PUT
    @Path(value="/set-realm-name")
    @Consumes(value={"application/json"})
    public void setRealmName(@QueryParam(value="realmName") String realmName) {
        if (realmName != null && !realmName.isEmpty()) {
            System.setProperty("keycloak.migration.realmName", realmName);
        } else {
            System.getProperties().remove("keycloak.migration.realmName");
        }
    }

    @GET
    @Path(value="/get-test-dir")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getExportImportTestDirectory() throws Exception {
        if (tempDir == null) {
            tempDir = Files.createTempDirectory("kc-tests", new FileAttribute[0]).toAbsolutePath().toString();
        }
        return tempDir;
    }

    @GET
    @Path(value="/clear")
    @Produces(value={"application/json"})
    public Response clear() {
        System.clearProperty("keycloak.migration.realmName");
        System.clearProperty("keycloak.migration.provider");
        System.clearProperty("keycloak.migration.action");
        System.clearProperty("keycloak.migration.file");
        return Response.noContent().build();
    }
}

