/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest.resource;

import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.mappers.membership.LDAPGroupMapperMode;
import org.keycloak.storage.ldap.mappers.membership.MembershipType;
import org.keycloak.storage.ldap.mappers.membership.group.GroupLDAPStorageMapperFactory;
import org.keycloak.storage.ldap.mappers.membership.role.RoleLDAPStorageMapperFactory;
import org.keycloak.testsuite.util.LDAPTestUtils;

public class TestLDAPResource {
    private final KeycloakSession session;
    private final RealmModel realm;

    public TestLDAPResource(KeycloakSession session, RealmModel realm) {
        this.session = session;
        this.realm = realm;
    }

    @POST
    @Path(value="/create-ldap-provider")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public String createLDAPProvider(Map<String, String> ldapCfg, @QueryParam(value="import") boolean importEnabled) {
        MultivaluedHashMap<String, String> ldapConfig = TestLDAPResource.toComponentConfig(ldapCfg);
        ldapConfig.putSingle((Object)"syncRegistrations", (Object)"true");
        ldapConfig.putSingle((Object)"editMode", (Object)UserStorageProvider.EditMode.WRITABLE.toString());
        UserStorageProviderModel model = new UserStorageProviderModel();
        model.setLastSync(0);
        model.setChangedSyncPeriod(-1);
        model.setFullSyncPeriod(-1);
        model.setName("test-ldap");
        model.setPriority(0);
        model.setProviderId("ldap");
        model.setConfig(ldapConfig);
        model.setImportEnabled(importEnabled);
        model.setCachePolicy(CacheableStorageProviderModel.CachePolicy.MAX_LIFESPAN);
        model.setMaxLifespan(600000L);
        ComponentModel ldapModel = this.realm.addComponentModel((ComponentModel)model);
        return ldapModel.getId();
    }

    private static MultivaluedHashMap<String, String> toComponentConfig(Map<String, String> ldapConfig) {
        MultivaluedHashMap config = new MultivaluedHashMap();
        for (Map.Entry<String, String> entry : ldapConfig.entrySet()) {
            config.add((Object)entry.getKey(), (Object)entry.getValue());
        }
        return config;
    }

    @POST
    @Path(value="/configure-groups")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void prepareGroupsLDAPTest() {
        LDAPTestUtils.addLocalUser(this.session, this.realm, "mary", "mary@test.com", "password-app");
        LDAPTestUtils.addLocalUser(this.session, this.realm, "john", "john@test.com", "password-app");
        ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel(this.realm);
        LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider(this.session, ldapModel);
        String descriptionAttrName = LDAPTestUtils.getGroupDescriptionLDAPAttrName(ldapFedProvider);
        LDAPTestUtils.addOrUpdateGroupMapper(this.realm, ldapModel, LDAPGroupMapperMode.LDAP_ONLY, descriptionAttrName, new String[0]);
        LDAPTestUtils.removeAllLDAPGroups(this.session, this.realm, ldapModel, "groupsMapper");
        LDAPObject group1 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "group1", descriptionAttrName, "group1 - description");
        LDAPObject group11 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "group11", new String[0]);
        LDAPObject group12 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "group12", descriptionAttrName, "group12 - description");
        LDAPObject defaultGroup1 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup1", descriptionAttrName, "Default Group1 - description");
        LDAPObject defaultGroup11 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup11", new String[0]);
        LDAPObject defaultGroup12 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup12", descriptionAttrName, "Default Group12 - description");
        LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team 2016/2017", descriptionAttrName, "A group with slashes in the name");
        LDAPObject teamChild20182019 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team Child 2018/2019", descriptionAttrName, "A child group with slashes in the name");
        LDAPObject teamSubChild20202021 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team SubChild 2020/2021", descriptionAttrName, "A sub child group with slashes in the name");
        LDAPObject defaultGroup13 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup13", descriptionAttrName, "Default Group13 - description");
        LDAPObject teamSubChild20222023 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team SubChild 2022/2023/A/B/C/D/E", descriptionAttrName, "A sub child group with slashes in the name");
        LDAPObject defaultGroup14 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup14", descriptionAttrName, "Default Group14 - description");
        LDAPObject teamRoot20242025 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team Root 2024/2025/A/B/C/D", descriptionAttrName, "A sub child group with slashes in the name");
        LDAPObject defaultGroup15 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "defaultGroup15", descriptionAttrName, "Default Group15 - description");
        LDAPObject teamSubChild20262027 = LDAPTestUtils.createLDAPGroup(this.session, this.realm, ldapModel, "Team SubChild 2026/2027", descriptionAttrName, "A sub child group with slashes in the name");
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group11);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)group12);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)defaultGroup1, (LDAPObject)defaultGroup11);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)defaultGroup1, (LDAPObject)defaultGroup12);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)defaultGroup1, (LDAPObject)teamChild20182019);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)teamChild20182019, (LDAPObject)teamSubChild20202021);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)defaultGroup13, (LDAPObject)teamSubChild20222023);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)teamSubChild20222023, (LDAPObject)defaultGroup14);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)teamRoot20242025, (LDAPObject)defaultGroup15);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)defaultGroup15, (LDAPObject)teamSubChild20262027);
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(this.realm, ldapModel, "groupsMapper");
        new GroupLDAPStorageMapperFactory().create(this.session, mapperModel).syncDataFromFederationProviderToKeycloak(this.realm);
        this.realm.addDefaultGroup(KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)"/defaultGroup1/defaultGroup11"));
        this.realm.addDefaultGroup(KeycloakModelUtils.findGroupByPath((RealmModel)this.realm, (String)"/defaultGroup1/defaultGroup12"));
        LDAPTestUtils.removeAllLDAPUsers(ldapFedProvider, this.realm);
        LDAPObject john = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "johnkeycloak", "John", "Doe", "john@email.org", null, "1234");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, john, "Password1");
        LDAPObject mary = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "marykeycloak", "Mary", "Kelly", "mary@email.org", null, "5678");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, mary, "Password1");
        LDAPObject rob = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "robkeycloak", "Rob", "Brown", "rob@email.org", null, "8910");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, rob, "Password1");
        LDAPObject james = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "jameskeycloak", "James", "Brown", "james@email.org", null, "8910");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, james, "Password1");
    }

    @POST
    @Path(value="/configure-roles")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void prepareRolesLDAPTest() {
        ComponentModel ldapModel = LDAPTestUtils.getLdapProviderModel(this.realm);
        LDAPStorageProvider ldapFedProvider = LDAPTestUtils.getLdapProvider(this.session, ldapModel);
        LDAPTestUtils.addOrUpdateRoleMapper(this.realm, ldapModel, LDAPGroupMapperMode.LDAP_ONLY, new String[0]);
        LDAPTestUtils.removeAllLDAPGroups(this.session, this.realm, ldapModel, "rolesMapper");
        LDAPTestUtils.removeAllLDAPUsers(ldapFedProvider, this.realm);
        LDAPObject john = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "johnkeycloak", "John", "Doe", "john@email.org", null, "1234");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, john, "Password1");
        LDAPObject mary = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "marykeycloak", "Mary", "Kelly", "mary@email.org", null, "5678");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, mary, "Password1");
        LDAPObject rob = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "robkeycloak", "Rob", "Brown", "rob@email.org", null, "8910");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, rob, "Password1");
        LDAPObject james = LDAPTestUtils.addLDAPUser(ldapFedProvider, this.realm, "jameskeycloak", "James", "Brown", "james@email.org", null, "8910");
        LDAPTestUtils.updateLDAPPassword(ldapFedProvider, james, "Password1");
        LDAPObject group1 = LDAPTestUtils.createLDAPGroup("rolesMapper", this.session, this.realm, ldapModel, "group1", new String[0]);
        LDAPObject group2 = LDAPTestUtils.createLDAPGroup("rolesMapper", this.session, this.realm, ldapModel, "group2", new String[0]);
        LDAPObject group3 = LDAPTestUtils.createLDAPGroup("rolesMapper", this.session, this.realm, ldapModel, "group3", new String[0]);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)john);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)mary);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group1, (LDAPObject)rob);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group2, (LDAPObject)john);
        LDAPUtils.addMember((LDAPStorageProvider)ldapFedProvider, (MembershipType)MembershipType.DN, (String)"member", (String)"not-used", (LDAPObject)group2, (LDAPObject)mary);
        ComponentModel mapperModel = LDAPTestUtils.getSubcomponentByName(this.realm, ldapModel, "rolesMapper");
        new RoleLDAPStorageMapperFactory().create(this.session, mapperModel).syncDataFromFederationProviderToKeycloak(this.realm);
    }

    @DELETE
    @Path(value="/remove-ldap-user")
    @Consumes(value={"application/json"})
    public void removeLDAPUser(@QueryParam(value="username") String ldapUsername) {
        ComponentModel ldapCompModel = LDAPTestUtils.getLdapProviderModel(this.realm);
        UserStorageProviderModel ldapModel = new UserStorageProviderModel(ldapCompModel);
        LDAPStorageProvider ldapProvider = LDAPTestUtils.getLdapProvider(this.session, (ComponentModel)ldapModel);
        LDAPTestUtils.removeLDAPUserByUsername(ldapProvider, this.realm, ldapProvider.getLdapIdentityStore().getConfig(), ldapUsername);
    }
}

