/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest.resource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.stream.CacheCollectors;
import org.jgroups.JChannel;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.testsuite.rest.representation.JGroupsStats;

public class TestCacheResource {
    private final Cache<Object, Object> cache;

    public TestCacheResource(KeycloakSession session, String cacheName) {
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache(cacheName);
    }

    @GET
    @Path(value="/contains/{id}")
    @Produces(value={"application/json"})
    public boolean contains(@PathParam(value="id") String id) {
        return this.cache.containsKey((Object)id);
    }

    @GET
    @Path(value="/contains-uuid/{id}")
    @Produces(value={"application/json"})
    public boolean containsUuid(@PathParam(value="id") String id) {
        UUID uuid = UUID.fromString(id);
        return this.cache.containsKey((Object)uuid);
    }

    @GET
    @Path(value="/enumerate-keys")
    @Produces(value={"application/json"})
    public Set<String> enumerateKeys() {
        HashSet keySet = new HashSet(this.cache.keySet());
        return (Set)keySet.stream().map(Object::toString).collect(CacheCollectors.serializableCollector(Collectors::toSet));
    }

    @GET
    @Path(value="/size")
    @Produces(value={"application/json"})
    public int size() {
        return this.cache.size();
    }

    @GET
    @Path(value="/clear")
    @Consumes(value={"text/plain; charset=utf-8"})
    public void clear() {
        this.cache.clear();
    }

    @POST
    @Path(value="/remove-key/{id}")
    @Produces(value={"application/json"})
    public void removeKey(@PathParam(value="id") String id) {
        this.cache.remove((Object)id);
    }

    @POST
    @Path(value="/process-expiration")
    @Produces(value={"application/json"})
    public void processExpiration() {
        this.cache.getAdvancedCache().getExpirationManager().processExpiration();
    }

    @GET
    @Path(value="/jgroups-stats")
    @Produces(value={"application/json"})
    public JGroupsStats getJgroupsStats() {
        Transport transport = this.cache.getCacheManager().getTransport();
        if (transport == null) {
            return new JGroupsStats(0L, 0L, 0L, 0L);
        }
        try {
            JChannel channel = (JChannel)transport.getClass().getMethod("getChannel", new Class[0]).invoke((Object)transport, new Object[0]);
            return new JGroupsStats(channel.getSentBytes(), channel.getSentMessages(), channel.getReceivedBytes(), channel.getReceivedMessages());
        }
        catch (Exception nsme) {
            throw new RuntimeException(nsme);
        }
    }

    @GET
    @Path(value="/remote-cache-stats")
    @Produces(value={"application/json"})
    public Map<String, String> getRemoteCacheStats() {
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(this.cache);
        if (remoteCache == null) {
            return new HashMap<String, String>();
        }
        return remoteCache.stats().getStatsMap();
    }

    @GET
    @Path(value="/remote-cache-last-session-refresh/{user-session-id}")
    @Produces(value={"application/json"})
    public int getRemoteCacheLastSessionRefresh(@PathParam(value="user-session-id") String userSessionId) {
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(this.cache);
        if (remoteCache == null) {
            return -1;
        }
        SessionEntityWrapper userSession = (SessionEntityWrapper)remoteCache.get((Object)userSessionId);
        if (userSession == null) {
            return -1;
        }
        return ((UserSessionEntity)userSession.getEntity()).getLastSessionRefresh();
    }
}

