/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.Profile;
import org.keycloak.common.util.HtmlUtils;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.events.Event;
import org.keycloak.events.EventQuery;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.events.admin.AdminEventQuery;
import org.keycloak.events.admin.AuthDetails;
import org.keycloak.events.admin.OperationType;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.protocol.oidc.mappers.AudienceProtocolMapper;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.representations.idm.AdminEventRepresentation;
import org.keycloak.representations.idm.AuthDetailsRepresentation;
import org.keycloak.representations.idm.AuthenticationFlowRepresentation;
import org.keycloak.representations.idm.EventRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.testsuite.components.TestProvider;
import org.keycloak.testsuite.components.TestProviderFactory;
import org.keycloak.testsuite.components.amphibian.TestAmphibianProvider;
import org.keycloak.testsuite.events.TestEventsListenerProvider;
import org.keycloak.testsuite.federation.DummyUserFederationProviderFactory;
import org.keycloak.testsuite.forms.PassThroughAuthenticator;
import org.keycloak.testsuite.forms.PassThroughClientAuthenticator;
import org.keycloak.testsuite.model.infinispan.InfinispanTestUtil;
import org.keycloak.testsuite.rest.TestClassLoader;
import org.keycloak.testsuite.rest.representation.AuthenticatorState;
import org.keycloak.testsuite.rest.resource.TestCacheResource;
import org.keycloak.testsuite.rest.resource.TestJavascriptResource;
import org.keycloak.testsuite.rest.resource.TestLDAPResource;
import org.keycloak.testsuite.rest.resource.TestingExportImportResource;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.RunOnServer;
import org.keycloak.testsuite.runonserver.SerializationUtil;
import org.keycloak.testsuite.util.FeatureDeployerUtil;
import org.keycloak.timer.TimerProvider;
import org.keycloak.util.JsonSerialization;

public class TestingResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final Map<String, TimerProvider.TimerTaskContext> suspendedTimerTasks;
    @Context
    private HttpRequest request;

    public Object getResource() {
        return this;
    }

    public TestingResourceProvider(KeycloakSession session, Map<String, TimerProvider.TimerTaskContext> suspendedTimerTasks) {
        this.session = session;
        this.suspendedTimerTasks = suspendedTimerTasks;
    }

    @POST
    @Path(value="/remove-user-session")
    @Produces(value={"application/json"})
    public Response removeUserSession(@QueryParam(value="realm") String name, @QueryParam(value="session") String sessionId) {
        RealmModel realm = this.getRealmByName(name);
        UserSessionModel sessionModel = this.session.sessions().getUserSession(realm, sessionId);
        if (sessionModel == null) {
            throw new NotFoundException("Session not found");
        }
        this.session.sessions().removeUserSession(realm, sessionModel);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/remove-user-sessions")
    @Produces(value={"application/json"})
    public Response removeUserSessions(@QueryParam(value="realm") String realmName) {
        RealmModel realm = this.getRealmByName(realmName);
        this.session.sessions().removeUserSessions(realm);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/get-last-session-refresh")
    @Produces(value={"application/json"})
    public Integer getLastSessionRefresh(@QueryParam(value="realm") String name, @QueryParam(value="session") String sessionId, @QueryParam(value="offline") boolean offline) {
        UserSessionModel sessionModel;
        RealmModel realm = this.getRealmByName(name);
        UserSessionModel userSessionModel = sessionModel = offline ? this.session.sessions().getOfflineUserSession(realm, sessionId) : this.session.sessions().getUserSession(realm, sessionId);
        if (sessionModel == null) {
            throw new NotFoundException("Session not found");
        }
        return sessionModel.getLastSessionRefresh();
    }

    @POST
    @Path(value="/remove-expired")
    @Produces(value={"application/json"})
    public Response removeExpired(@QueryParam(value="realm") String name) {
        RealmModel realm = this.getRealmByName(name);
        this.session.sessions().removeExpired(realm);
        this.session.authenticationSessions().removeExpired(realm);
        this.session.realms().removeExpiredClientInitialAccess();
        return Response.noContent().build();
    }

    @POST
    @Path(value="/set-testing-infinispan-time-service")
    @Produces(value={"application/json"})
    public Response setTestingInfinispanTimeService() {
        InfinispanTestUtil.setTestingTimeService(this.session);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/revert-testing-infinispan-time-service")
    @Produces(value={"application/json"})
    public Response revertTestingInfinispanTimeService() {
        InfinispanTestUtil.revertTimeService();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/get-client-sessions-count")
    @Produces(value={"application/json"})
    public Integer getClientSessionsCountInUserSession(@QueryParam(value="realm") String name, @QueryParam(value="session") String sessionId) {
        RealmModel realm = this.getRealmByName(name);
        UserSessionModel sessionModel = this.session.sessions().getUserSession(realm, sessionId);
        if (sessionModel == null) {
            throw new NotFoundException("Session not found");
        }
        return sessionModel.getAuthenticatedClientSessions().size();
    }

    @GET
    @Path(value="/time-offset")
    @Produces(value={"application/json"})
    public Map<String, String> getTimeOffset() {
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("currentTime", String.valueOf(Time.currentTime()));
        response.put("offset", String.valueOf(Time.getOffset()));
        return response;
    }

    @PUT
    @Path(value="/time-offset")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> setTimeOffset(Map<String, String> time) {
        int offset = Integer.parseInt(time.get("offset"));
        Time.setOffset((int)offset);
        if (offset == 0) {
            this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ResetTimeOffsetEvent());
        }
        return this.getTimeOffset();
    }

    @POST
    @Path(value="/poll-event-queue")
    @Produces(value={"application/json"})
    public EventRepresentation getEvent() {
        Event event = TestEventsListenerProvider.poll();
        if (event != null) {
            return ModelToRepresentation.toRepresentation((Event)event);
        }
        return null;
    }

    @POST
    @Path(value="/poll-admin-event-queue")
    @Produces(value={"application/json"})
    public AdminEventRepresentation getAdminEvent() {
        AdminEvent adminEvent = TestEventsListenerProvider.pollAdminEvent();
        if (adminEvent != null) {
            return ModelToRepresentation.toRepresentation((AdminEvent)adminEvent);
        }
        return null;
    }

    @POST
    @Path(value="/clear-event-queue")
    @Produces(value={"application/json"})
    public Response clearEventQueue() {
        TestEventsListenerProvider.clear();
        return Response.noContent().build();
    }

    @POST
    @Path(value="/clear-admin-event-queue")
    @Produces(value={"application/json"})
    public Response clearAdminEventQueue() {
        TestEventsListenerProvider.clearAdminEvents();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear-event-store")
    @Produces(value={"application/json"})
    public Response clearEventStore() {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear-event-store-for-realm")
    @Produces(value={"application/json"})
    public Response clearEventStore(@QueryParam(value="realmId") String realmId) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clear(realmId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear-expired-events")
    @Produces(value={"application/json"})
    public Response clearExpiredEvents() {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearExpiredEvents();
        return Response.noContent().build();
    }

    @Path(value="query-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<EventRepresentation> queryEvents(@QueryParam(value="realmId") String realmId, @QueryParam(value="type") List<String> types, @QueryParam(value="client") String client, @QueryParam(value="user") String user, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        EventQuery query = eventStore.createQuery();
        if (realmId != null) {
            query.realm(realmId);
        }
        if (client != null) {
            query.client(client);
        }
        if (types != null & !types.isEmpty()) {
            EventType[] t = new EventType[types.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = EventType.valueOf((String)types.get(i));
            }
            query.type(t);
        }
        if (user != null) {
            query.user(user);
        }
        if (dateFrom != null) {
            Date from = this.formatDate(dateFrom, "Date(From)");
            query.fromDate(from);
        }
        if (dateTo != null) {
            Date to = this.formatDate(dateTo, "Date(To)");
            query.toDate(to);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    @PUT
    @Path(value="/on-event")
    @Consumes(value={"application/json"})
    public void onEvent(EventRepresentation rep) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.onEvent(this.repToModel(rep));
    }

    private Event repToModel(EventRepresentation rep) {
        Event event = new Event();
        event.setId(UUID.randomUUID().toString());
        event.setClientId(rep.getClientId());
        event.setDetails(rep.getDetails());
        event.setError(rep.getError());
        event.setIpAddress(rep.getIpAddress());
        event.setRealmId(rep.getRealmId());
        event.setSessionId(rep.getSessionId());
        event.setTime(rep.getTime());
        event.setType(EventType.valueOf((String)rep.getType()));
        event.setUserId(rep.getUserId());
        return event;
    }

    @GET
    @Path(value="/clear-admin-event-store")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore() {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin();
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear-admin-event-store-for-realm")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore(@QueryParam(value="realmId") String realmId) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(realmId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear-admin-event-store-older-than")
    @Produces(value={"application/json"})
    public Response clearAdminEventStore(@QueryParam(value="realmId") String realmId, @QueryParam(value="olderThan") long olderThan) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.clearAdmin(realmId, olderThan);
        return Response.noContent().build();
    }

    @Path(value="query-admin-events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Stream<AdminEventRepresentation> getAdminEvents(@QueryParam(value="realmId") String realmId, @QueryParam(value="operationTypes") List<String> operationTypes, @QueryParam(value="authRealm") String authRealm, @QueryParam(value="authClient") String authClient, @QueryParam(value="authUser") String authUser, @QueryParam(value="authIpAddress") String authIpAddress, @QueryParam(value="resourcePath") String resourcePath, @QueryParam(value="dateFrom") String dateFrom, @QueryParam(value="dateTo") String dateTo, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        AdminEventQuery query = eventStore.createAdminQuery();
        if (realmId != null) {
            query.realm(realmId);
        }
        if (authRealm != null) {
            query.authRealm(authRealm);
        }
        if (authClient != null) {
            query.authClient(authClient);
        }
        if (authUser != null) {
            query.authUser(authUser);
        }
        if (authIpAddress != null) {
            query.authIpAddress(authIpAddress);
        }
        if (resourcePath != null) {
            query.resourcePath(resourcePath);
        }
        if (operationTypes != null && !operationTypes.isEmpty()) {
            OperationType[] t = new OperationType[operationTypes.size()];
            for (int i = 0; i < t.length; ++i) {
                t[i] = OperationType.valueOf((String)operationTypes.get(i));
            }
            query.operation(t);
        }
        if (dateFrom != null) {
            Date from = this.formatDate(dateFrom, "Date(From)");
            query.fromTime(from);
        }
        if (dateTo != null) {
            Date to = this.formatDate(dateTo, "Date(To)");
            query.toTime(to);
        }
        if (firstResult != null || maxResults != null) {
            if (firstResult == null) {
                firstResult = 0;
            }
            if (maxResults == null) {
                maxResults = 100;
            }
            query.firstResult(firstResult.intValue());
            query.maxResults(maxResults.intValue());
        }
        return query.getResultStream().map(ModelToRepresentation::toRepresentation);
    }

    private Date formatDate(String date, String paramName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new BadRequestException("Invalid value for '" + paramName + "', expected format is yyyy-MM-dd");
        }
    }

    @POST
    @Path(value="/on-admin-event")
    @Consumes(value={"application/json"})
    public void onAdminEvent(AdminEventRepresentation rep, @QueryParam(value="includeRepresentation") boolean includeRepresentation) {
        EventStoreProvider eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
        eventStore.onEvent(this.repToModel(rep), includeRepresentation);
    }

    private AdminEvent repToModel(AdminEventRepresentation rep) {
        AdminEvent event = new AdminEvent();
        event.setId(UUID.randomUUID().toString());
        event.setAuthDetails(this.repToModel(rep.getAuthDetails()));
        event.setError(rep.getError());
        event.setOperationType(OperationType.valueOf((String)rep.getOperationType()));
        if (rep.getResourceType() != null) {
            event.setResourceTypeAsString(rep.getResourceType());
        }
        event.setRealmId(rep.getRealmId());
        event.setRepresentation(rep.getRepresentation());
        event.setResourcePath(rep.getResourcePath());
        event.setTime(rep.getTime());
        return event;
    }

    private AuthDetails repToModel(AuthDetailsRepresentation rep) {
        AuthDetails details = new AuthDetails();
        details.setClientId(rep.getClientId());
        details.setIpAddress(rep.getIpAddress());
        details.setRealmId(rep.getRealmId());
        details.setUserId(rep.getUserId());
        return details;
    }

    @GET
    @Path(value="/get-sso-cookie")
    @Produces(value={"application/json"})
    public String getSSOCookieValue() {
        Map cookies = this.request.getHttpHeaders().getCookies();
        Cookie cookie = CookieHelper.getCookie((Map)cookies, (String)"KEYCLOAK_IDENTITY");
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Path(value="/cache/{cache}")
    public TestCacheResource getCacheResource(@PathParam(value="cache") String cacheName) {
        return new TestCacheResource(this.session, cacheName);
    }

    @Path(value="/ldap/{realm}")
    public TestLDAPResource ldap(@PathParam(value="realm") String realmName) {
        RealmModel realm = this.session.realms().getRealmByName(realmName);
        return new TestLDAPResource(this.session, realm);
    }

    public void close() {
    }

    @POST
    @Path(value="/update-pass-through-auth-state")
    @Produces(value={"application/json"})
    public AuthenticatorState updateAuthenticator(AuthenticatorState state) {
        if (state.getClientId() != null) {
            PassThroughClientAuthenticator.clientId = state.getClientId();
        }
        if (state.getUsername() != null) {
            PassThroughAuthenticator.username = state.getUsername();
        }
        AuthenticatorState result = new AuthenticatorState();
        result.setClientId(PassThroughClientAuthenticator.clientId);
        result.setUsername(PassThroughAuthenticator.username);
        return result;
    }

    @GET
    @Path(value="/valid-credentials")
    @Produces(value={"application/json"})
    public boolean validCredentials(@QueryParam(value="realmName") String realmName, @QueryParam(value="userName") String userName, @QueryParam(value="password") String password) {
        RealmModel realm = this.session.realms().getRealm(realmName);
        if (realm == null) {
            return false;
        }
        UserProvider userProvider = (UserProvider)this.session.getProvider(UserProvider.class);
        UserModel user = userProvider.getUserByUsername(realm, userName);
        return this.session.userCredentialManager().isValid(realm, user, new CredentialInput[]{UserCredentialModel.password((String)password)});
    }

    @GET
    @Path(value="/user-by-federated-identity")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByFederatedIdentity(@QueryParam(value="realmName") String realmName, @QueryParam(value="identityProvider") String identityProvider, @QueryParam(value="userId") String userId, @QueryParam(value="userName") String userName) {
        RealmModel realm = this.getRealmByName(realmName);
        UserModel foundFederatedUser = this.session.users().getUserByFederatedIdentity(realm, new FederatedIdentityModel(identityProvider, userId, userName));
        if (foundFederatedUser == null) {
            return null;
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)foundFederatedUser);
    }

    @GET
    @Path(value="/user-by-username-from-fed-factory")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByUsernameFromFedProviderFactory(@QueryParam(value="realmName") String realmName, @QueryParam(value="userName") String userName) {
        RealmModel realm = this.getRealmByName(realmName);
        DummyUserFederationProviderFactory factory = (DummyUserFederationProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserStorageProvider.class, "dummy");
        UserModel user = factory.create(this.session, null).getUserByUsername(realm, userName);
        if (user == null) {
            return null;
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
    }

    @GET
    @Path(value="/get-client-auth-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getClientAuthFlow(@QueryParam(value="realmName") String realmName) {
        RealmModel realm = this.getRealmByName(realmName);
        AuthenticationFlowModel flow = realm.getClientAuthenticationFlow();
        if (flow == null) {
            return null;
        }
        return ModelToRepresentation.toRepresentation((RealmModel)realm, (AuthenticationFlowModel)flow);
    }

    @GET
    @Path(value="/get-reset-cred-flow")
    @Produces(value={"application/json"})
    public AuthenticationFlowRepresentation getResetCredFlow(@QueryParam(value="realmName") String realmName) {
        RealmModel realm = this.getRealmByName(realmName);
        AuthenticationFlowModel flow = realm.getResetCredentialsFlow();
        if (flow == null) {
            return null;
        }
        return ModelToRepresentation.toRepresentation((RealmModel)realm, (AuthenticationFlowModel)flow);
    }

    @GET
    @Path(value="/get-user-by-service-account-client")
    @Produces(value={"application/json"})
    public UserRepresentation getUserByServiceAccountClient(@QueryParam(value="realmName") String realmName, @QueryParam(value="clientId") String clientId) {
        RealmModel realm = this.getRealmByName(realmName);
        ClientModel client = realm.getClientByClientId(clientId);
        UserModel user = this.session.users().getServiceAccount(client);
        if (user == null) {
            return null;
        }
        return ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)realm, (UserModel)user);
    }

    @Path(value="/export-import")
    public TestingExportImportResource getExportImportResource() {
        return new TestingExportImportResource(this.session);
    }

    @GET
    @Path(value="/test-component")
    @Produces(value={"application/json"})
    public Map<String, TestProvider.DetailsRepresentation> getTestComponentDetails() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), TestProvider.class.getName()).collect(Collectors.toMap(ComponentModel::getName, componentModel -> {
            ProviderFactory f = this.session.getKeycloakSessionFactory().getProviderFactory(TestProvider.class, componentModel.getProviderId());
            TestProviderFactory factory = (TestProviderFactory)f;
            TestProvider p = (TestProvider)factory.create(this.session, (ComponentModel)componentModel);
            return p.getDetails();
        }));
    }

    @GET
    @Path(value="/test-amphibian-component")
    @Produces(value={"application/json"})
    public Map<String, Map<String, Object>> getTestAmphibianComponentDetails() {
        RealmModel realm = this.session.getContext().getRealm();
        return realm.getComponentsStream(realm.getId(), TestAmphibianProvider.class.getName()).collect(Collectors.toMap(ComponentModel::getName, componentModel -> {
            TestAmphibianProvider t = (TestAmphibianProvider)this.session.getComponentProvider(TestAmphibianProvider.class, componentModel.getId());
            return t == null ? null : t.getDetails();
        }));
    }

    @GET
    @Path(value="/identity-config")
    @Produces(value={"application/json"})
    public Map<String, String> getIdentityProviderConfig(@QueryParam(value="alias") String alias) {
        return this.session.getContext().getRealm().getIdentityProviderByAlias(alias).getConfig();
    }

    @PUT
    @Path(value="/set-krb5-conf-file")
    @Consumes(value={"application/json"})
    public void setKrb5ConfFile(@QueryParam(value="krb5-conf-file") String krb5ConfFile) {
        System.setProperty("java.security.krb5.conf", krb5ConfFile);
    }

    @POST
    @Path(value="/suspend-periodic-tasks")
    @Produces(value={"application/json"})
    public Response suspendPeriodicTasks() {
        this.suspendTask("ClearExpiredUserSessions");
        this.suspendTask("lastSessionRefreshes");
        this.suspendTask("lastSessionRefreshes-offline");
        return Response.noContent().build();
    }

    @GET
    @Path(value="/uncaught-error")
    public Response uncaughtError() {
        throw new RuntimeException("Uncaught error");
    }

    private void suspendTask(String taskName) {
        TimerProvider.TimerTaskContext taskContext = ((TimerProvider)this.session.getProvider(TimerProvider.class)).cancelTask(taskName);
        if (taskContext != null) {
            this.suspendedTimerTasks.put(taskName, taskContext);
        }
    }

    @POST
    @Path(value="/restore-periodic-tasks")
    @Produces(value={"application/json"})
    public Response restorePeriodicTasks() {
        TimerProvider timer = (TimerProvider)this.session.getProvider(TimerProvider.class);
        for (Map.Entry<String, TimerProvider.TimerTaskContext> task : this.suspendedTimerTasks.entrySet()) {
            timer.schedule(task.getValue().getRunnable(), task.getValue().getIntervalMillis(), task.getKey());
        }
        this.suspendedTimerTasks.clear();
        return Response.noContent().build();
    }

    @Path(value="generate-audience-client-scope")
    @POST
    @NoCache
    public String generateAudienceClientScope(@QueryParam(value="realm") String realmName, @QueryParam(value="clientId") String clientId) {
        try {
            RealmModel realm = this.getRealmByName(realmName);
            ClientModel serviceClient = realm.getClientByClientId(clientId);
            if (serviceClient == null) {
                throw new NotFoundException("Referenced service client doesn't exist");
            }
            ClientScopeModel clientScopeModel = realm.addClientScope(clientId);
            clientScopeModel.setProtocol(serviceClient.getProtocol() == null ? "openid-connect" : serviceClient.getProtocol());
            clientScopeModel.setDisplayOnConsentScreen(true);
            clientScopeModel.setConsentScreenText(clientId);
            clientScopeModel.setIncludeInTokenScope(true);
            ProtocolMapperModel audienceMapper = AudienceProtocolMapper.createClaimMapper((String)("Audience for " + clientId), (String)clientId, null, (boolean)true, (boolean)false);
            clientScopeModel.addProtocolMapper(audienceMapper);
            return clientScopeModel.getId();
        }
        catch (ModelDuplicateException e) {
            throw new BadRequestException("Client Scope " + clientId + " already exists");
        }
    }

    @POST
    @Path(value="/run-on-server")
    @Consumes(value={"text/plain; charset=utf-8"})
    @Produces(value={"text/plain; charset=utf-8"})
    public String runOnServer(String runOnServer) throws Exception {
        try {
            Object r = SerializationUtil.decode(runOnServer, TestClassLoader.getInstance());
            if (r instanceof FetchOnServer) {
                Object result = ((FetchOnServer)r).run(this.session);
                return result != null ? JsonSerialization.writeValueAsString((Object)result) : null;
            }
            if (r instanceof RunOnServer) {
                ((RunOnServer)r).run(this.session);
                return null;
            }
            throw new IllegalArgumentException();
        }
        catch (Throwable t) {
            return SerializationUtil.encodeException(t);
        }
    }

    @POST
    @Path(value="/run-model-test-on-server")
    @Consumes(value={"text/plain; charset=utf-8"})
    @Produces(value={"text/plain; charset=utf-8"})
    public String runModelTestOnServer(@QueryParam(value="testClassName") String testClassName, @QueryParam(value="testMethodName") String testMethodName) throws Exception {
        try {
            Class<?> testClass = TestClassLoader.getInstance().loadClass(testClassName);
            Method testMethod = testClass.getDeclaredMethod(testMethodName, KeycloakSession.class);
            Object test = testClass.newInstance();
            testMethod.invoke(test, this.session);
            return "SUCCESS";
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            return SerializationUtil.encodeException(t);
        }
    }

    @Path(value="/javascript")
    public TestJavascriptResource getJavascriptResource() {
        return new TestJavascriptResource(this.session);
    }

    private void setFeatureInProfileFile(File file, Profile.Feature featureProfile, String newState) {
        Throwable throwable;
        Properties properties = new Properties();
        if (file.isFile() && file.exists()) {
            try {
                throwable = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    properties.load(fis);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read profile.properties file");
            }
        }
        properties.setProperty("feature." + featureProfile.toString().toLowerCase(), newState);
        try {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                properties.store(fos, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to profile.properties file");
        }
    }

    @POST
    @Path(value="/enable-feature/{feature}")
    @Consumes(value={"application/json"})
    public Response enableFeature(@PathParam(value="feature") String feature) {
        Profile.Feature featureProfile;
        try {
            featureProfile = Profile.Feature.valueOf((String)feature);
        }
        catch (IllegalArgumentException e) {
            System.err.printf("Feature '%s' doesn't exist!!\n", feature);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (Profile.isFeatureEnabled((Profile.Feature)featureProfile)) {
            return Response.noContent().build();
        }
        FeatureDeployerUtil.initBeforeChangeFeature(featureProfile);
        System.setProperty("keycloak.profile.feature." + featureProfile.toString().toLowerCase(), "enabled");
        String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
        if (jbossServerConfigDir != null) {
            this.setFeatureInProfileFile(new File(jbossServerConfigDir, "profile.properties"), featureProfile, "enabled");
        }
        Profile.init();
        FeatureDeployerUtil.deployFactoriesAfterFeatureEnabled(featureProfile);
        if (Profile.isFeatureEnabled((Profile.Feature)featureProfile)) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Path(value="/disable-feature/{feature}")
    @Consumes(value={"application/json"})
    public Response disableFeature(@PathParam(value="feature") String feature) {
        Profile.Feature featureProfile;
        try {
            featureProfile = Profile.Feature.valueOf((String)feature);
        }
        catch (IllegalArgumentException e) {
            System.err.printf("Feature '%s' doesn't exist!!\n", feature);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (!Profile.isFeatureEnabled((Profile.Feature)featureProfile)) {
            return Response.noContent().build();
        }
        FeatureDeployerUtil.initBeforeChangeFeature(featureProfile);
        this.disableFeatureProperties(featureProfile);
        String jbossServerConfigDir = System.getProperty("jboss.server.config.dir");
        if (jbossServerConfigDir != null) {
            this.setFeatureInProfileFile(new File(jbossServerConfigDir, "profile.properties"), featureProfile, "disabled");
        }
        Profile.init();
        FeatureDeployerUtil.undeployFactoriesAfterFeatureDisabled(featureProfile);
        if (!Profile.isFeatureEnabled((Profile.Feature)featureProfile)) {
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private void disableFeatureProperties(Profile.Feature feature) {
        Profile.Type type;
        Profile.Type type2 = type = Profile.getName().equals("product") ? feature.getTypeProduct() : feature.getTypeProject();
        if (type.equals((Object)Profile.Type.DEFAULT)) {
            System.setProperty("keycloak.profile.feature." + feature.toString().toLowerCase(), "disabled");
        } else {
            System.getProperties().remove("keycloak.profile.feature." + feature.toString().toLowerCase());
        }
    }

    @GET
    @Path(value="/set-system-property")
    @Consumes(value={"text/html; charset=utf-8"})
    @NoCache
    public void setSystemPropertyOnServer(@QueryParam(value="property-name") String propertyName, @QueryParam(value="property-value") String propertyValue) {
        if (propertyValue == null) {
            System.getProperties().remove(propertyName);
        } else {
            System.setProperty(propertyName, propertyValue);
        }
    }

    @GET
    @Path(value="/simulate-post-request")
    @Produces(value={"text/html; charset=utf-8"})
    public Response simulatePostRequest(@QueryParam(value="postRequestUrl") String postRequestUrl, @QueryParam(value="encodedFormParameters") String encodedFormParameters) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : encodedFormParameters.split("&")) {
            String[] paramParts = param.split("=");
            String value = paramParts.length == 2 ? paramParts[1] : "";
            params.put(paramParts[0], value);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("  <HEAD>");
        builder.append("    <TITLE>OIDC Form_Post Response</TITLE>");
        builder.append("  </HEAD>");
        builder.append("  <BODY Onload=\"document.forms[0].submit()\">");
        builder.append("    <FORM METHOD=\"POST\" ACTION=\"" + postRequestUrl + "\">");
        for (Map.Entry param : params.entrySet()) {
            builder.append("  <INPUT TYPE=\"HIDDEN\" NAME=\"").append((String)param.getKey()).append("\" VALUE=\"").append(HtmlUtils.escapeAttribute((String)((String)param.getValue()))).append("\" />");
        }
        builder.append("      <NOSCRIPT>");
        builder.append("        <P>JavaScript is disabled. We strongly recommend to enable it. Click the button below to continue .</P>");
        builder.append("        <INPUT name=\"continue\" TYPE=\"SUBMIT\" VALUE=\"CONTINUE\" />");
        builder.append("      </NOSCRIPT>");
        builder.append("    </FORM>");
        builder.append("  </BODY>");
        builder.append("</HTML>");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.TEXT_HTML_TYPE).entity((Object)builder.toString()).build();
    }

    private RealmModel getRealmByName(String realmName) {
        RealmProvider realmProvider = (RealmProvider)this.session.getProvider(RealmProvider.class);
        RealmModel realm = realmProvider.getRealmByName(realmName);
        if (realm == null) {
            throw new NotFoundException("Realm not found");
        }
        return realm;
    }
}

