/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.RealmsResource;

public class TestSamlApplicationResourceProvider
implements RealmResourceProvider {
    private final KeycloakSession session;
    private final BlockingQueue<LogoutAction> adminLogoutActions;
    private final BlockingQueue<PushNotBeforeAction> adminPushNotBeforeActions;
    private final BlockingQueue<TestAvailabilityAction> adminTestAvailabilityAction;

    public TestSamlApplicationResourceProvider(KeycloakSession session, BlockingQueue<LogoutAction> adminLogoutActions, BlockingQueue<PushNotBeforeAction> adminPushNotBeforeActions, BlockingQueue<TestAvailabilityAction> adminTestAvailabilityAction) {
        this.session = session;
        this.adminLogoutActions = adminLogoutActions;
        this.adminPushNotBeforeActions = adminPushNotBeforeActions;
        this.adminTestAvailabilityAction = adminTestAvailabilityAction;
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/saml/k_logout")
    public void adminLogout(String data) throws JWSInputException {
        this.adminLogoutActions.add((LogoutAction)new JWSInput(data).readJsonContent(LogoutAction.class));
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/saml/k_push_not_before")
    public void adminPushNotBefore(String data) throws JWSInputException {
        this.adminPushNotBeforeActions.add((PushNotBeforeAction)new JWSInput(data).readJsonContent(PushNotBeforeAction.class));
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/saml/k_test_available")
    public void testAvailable(String data) throws JWSInputException {
        this.adminTestAvailabilityAction.add((TestAvailabilityAction)new JWSInput(data).readJsonContent(TestAvailabilityAction.class));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-admin-logout")
    public LogoutAction getAdminLogoutAction() throws InterruptedException {
        return this.adminLogoutActions.poll(10L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-admin-not-before")
    public PushNotBeforeAction getAdminPushNotBefore() throws InterruptedException {
        return this.adminPushNotBeforeActions.poll(10L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-test-available")
    public TestAvailabilityAction getTestAvailable() throws InterruptedException {
        return this.adminTestAvailabilityAction.poll(10L, TimeUnit.SECONDS);
    }

    @POST
    @Path(value="/clear-admin-actions")
    public Response clearAdminActions() {
        this.adminLogoutActions.clear();
        this.adminPushNotBeforeActions.clear();
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"text/html; charset=utf-8"})
    @Path(value="/{action}")
    public String post(@PathParam(value="action") String action) {
        String title = "APP_REQUEST";
        if (action.equals("auth")) {
            title = "AUTH_RESPONSE";
        } else if (action.equals("logout")) {
            title = "LOGOUT_REQUEST";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>" + title + "</title></head><body>");
        sb.append("<b>Form parameters: </b><br>");
        HttpRequest request = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
        MultivaluedMap formParams = request.getDecodedFormParameters();
        for (String paramName : formParams.keySet()) {
            sb.append(paramName).append(": ").append("<span id=\"").append(paramName).append("\">").append((String)formParams.getFirst((Object)paramName)).append("</span><br>");
        }
        sb.append("<br>");
        UriBuilder base = UriBuilder.fromUri((String)"/auth");
        sb.append("<a href=\"" + RealmsResource.accountUrl((UriBuilder)base).build(new Object[]{"test"}).toString() + "\" id=\"account\">account</a>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    @Path(value="/{action}")
    public String get(@PathParam(value="action") String action) {
        String title = "APP_REQUEST";
        if (action.equals("auth")) {
            title = "AUTH_RESPONSE";
        } else if (action.equals("logout")) {
            title = "LOGOUT_REQUEST";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>" + title + "</title></head><body>");
        UriBuilder base = UriBuilder.fromUri((String)"/auth");
        sb.append("<a href=\"" + RealmsResource.accountUrl((UriBuilder)base).build(new Object[]{"test"}).toString() + "\" id=\"account\">account</a>");
        sb.append("</body></html>");
        return sb.toString();
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }
}

