/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest;

import java.security.KeyPair;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.Config;
import org.keycloak.crypto.KeyUse;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resource.RealmResourceProviderFactory;
import org.keycloak.testsuite.rest.TestApplicationResourceProvider;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;

public class TestApplicationResourceProviderFactory
implements RealmResourceProviderFactory {
    private BlockingQueue<LogoutAction> adminLogoutActions = new LinkedBlockingDeque<LogoutAction>();
    private BlockingQueue<LogoutToken> backChannelLogoutTokens = new LinkedBlockingDeque<LogoutToken>();
    private BlockingQueue<LogoutToken> frontChannelLogoutTokens = new LinkedBlockingDeque<LogoutToken>();
    private BlockingQueue<PushNotBeforeAction> pushNotBeforeActions = new LinkedBlockingDeque<PushNotBeforeAction>();
    private BlockingQueue<TestAvailabilityAction> testAvailabilityActions = new LinkedBlockingDeque<TestAvailabilityAction>();
    private final OIDCClientData oidcClientData = new OIDCClientData();
    private ConcurrentMap<String, TestAuthenticationChannelRequest> authenticationChannelRequests = new ConcurrentHashMap<String, TestAuthenticationChannelRequest>();
    private ConcurrentMap<String, ClientNotificationEndpointRequest> cibaClientNotifications = new ConcurrentHashMap<String, ClientNotificationEndpointRequest>();

    public RealmResourceProvider create(KeycloakSession session) {
        TestApplicationResourceProvider provider = new TestApplicationResourceProvider(session, this.adminLogoutActions, this.backChannelLogoutTokens, this.frontChannelLogoutTokens, this.pushNotBeforeActions, this.testAvailabilityActions, this.oidcClientData, this.authenticationChannelRequests, this.cibaClientNotifications);
        ResteasyProviderFactory.getInstance().injectProperties((Object)provider);
        return provider;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "app";
    }

    public static class OIDCClientData {
        private KeyPair keyPair;
        private String oidcRequest;
        private List<String> sectorIdentifierRedirectUris;
        private String keyType = "RSA";
        private String keyAlgorithm;
        private KeyUse keyUse = KeyUse.SIG;

        public KeyPair getSigningKeyPair() {
            return this.keyPair;
        }

        public void setSigningKeyPair(KeyPair signingKeyPair) {
            this.keyPair = signingKeyPair;
        }

        public String getOidcRequest() {
            return this.oidcRequest;
        }

        public void setOidcRequest(String oidcRequest) {
            this.oidcRequest = oidcRequest;
        }

        public List<String> getSectorIdentifierRedirectUris() {
            return this.sectorIdentifierRedirectUris;
        }

        public void setSectorIdentifierRedirectUris(List<String> sectorIdentifierRedirectUris) {
            this.sectorIdentifierRedirectUris = sectorIdentifierRedirectUris;
        }

        public String getSigningKeyType() {
            return this.keyType;
        }

        public void setSigningKeyType(String signingKeyType) {
            this.keyType = signingKeyType;
        }

        public String getSigningKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public void setSigningKeyAlgorithm(String signingKeyAlgorithm) {
            this.keyAlgorithm = signingKeyAlgorithm;
        }

        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        public void setKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        public void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public KeyUse getKeyUse() {
            return this.keyUse;
        }

        public void setKeyUse(KeyUse keyUse) {
            this.keyUse = keyUse;
        }
    }
}

