/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.model.infinispan;

import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;

public class InfinispanTestUtil {
    protected static final Logger logger = Logger.getLogger(InfinispanTestUtil.class);
    private static Runnable origTimeService = null;

    public static void setTestingTimeService(KeycloakSession session) {
        if (origTimeService != null) {
            throw new IllegalStateException("Calling setTestingTimeService when testing TimeService was already set");
        }
        logger.info((Object)"Will set KeycloakIspnTimeService to the infinispan cacheManager");
        InfinispanConnectionProvider ispnProvider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        EmbeddedCacheManager cacheManager = ispnProvider.getCache("sessions").getCacheManager();
        origTimeService = InfinispanUtil.setTimeServiceToKeycloakTime((EmbeddedCacheManager)cacheManager);
    }

    public static void revertTimeService() {
        if (origTimeService == null) {
            throw new IllegalStateException("Calling revertTimeService when testing TimeService was not set");
        }
        origTimeService.run();
        origTimeService = null;
    }
}

