/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.FlowStatus;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.ClientIdAndSecretAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.provider.ProviderConfigProperty;

public class DummyClientAuthenticator
extends AbstractClientAuthenticator {
    public static final String PROVIDER_ID = "testsuite-client-dummy";

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        ClientModel client;
        ClientIdAndSecretAuthenticator authenticator = new ClientIdAndSecretAuthenticator();
        authenticator.authenticateClient(context);
        if (context.getStatus().equals((Object)FlowStatus.SUCCESS)) {
            return;
        }
        String clientId = (String)context.getUriInfo().getQueryParameters().getFirst((Object)"client_id");
        if (clientId == null) {
            clientId = (String)context.getSession().getAttribute("client_id", String.class);
        }
        if ((client = context.getRealm().getClientByClientId(clientId)) == null) {
            context.failure(AuthenticationFlowError.CLIENT_NOT_FOUND, null);
            return;
        }
        context.getEvent().client(client);
        context.setClient(client);
        context.success();
    }

    public String getDisplayType() {
        return "Testsuite ClientId Dummy";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Dummy client authenticator, which authenticates the client with clientId only";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new LinkedList<ProviderConfigProperty>();
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        return Collections.emptyMap();
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        return Collections.emptySet();
    }
}

