/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation.sync;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.DummyUserFederationProviderFactory;

public class SyncDummyUserFederationProviderFactory
extends DummyUserFederationProviderFactory {
    public static volatile CountDownLatch latch1 = new CountDownLatch(1);
    public static volatile CountDownLatch latch2 = new CountDownLatch(1);
    private static final Logger logger = Logger.getLogger(SyncDummyUserFederationProviderFactory.class);
    public static final String SYNC_PROVIDER_ID = "sync-dummy";
    public static final String WAIT_TIME = "wait-time";

    public static void restartLatches() {
        latch1 = new CountDownLatch(1);
        latch2 = new CountDownLatch(1);
    }

    @Override
    public String getId() {
        return SYNC_PROVIDER_ID;
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("important.config").type("String").add().property().name(WAIT_TIME).type("String").add().build();
    }

    @Override
    public SynchronizationResult syncSince(Date lastSync, KeycloakSessionFactory sessionFactory, final String realmId, final UserStorageProviderModel model) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                int waitTime = Integer.parseInt((String)model.getConfig().getFirst((Object)SyncDummyUserFederationProviderFactory.WAIT_TIME));
                logger.infof("Starting sync of changed users. Wait time is: %s", (Object)waitTime);
                RealmModel realm = session.realms().getRealm(realmId);
                for (int i = 0; i < 10; ++i) {
                    String username = "dummyuser-" + i;
                    UserModel user = session.userLocalStorage().getUserByUsername(realm, username);
                    if (user != null) {
                        session.userLocalStorage().removeUser(realm, user);
                    }
                    user = session.userLocalStorage().addUser(realm, username);
                }
                logger.infof("Finished sync of changed users. Waiting now for %d seconds", (Object)waitTime);
                try {
                    latch1.await(waitTime * 1000, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted!", ie);
                }
                logger.infof("Finished waiting", new Object[0]);
            }
        });
        latch2.countDown();
        return new SynchronizationResult();
    }
}

