/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.keycloak.Config;
import org.keycloak.common.util.EnvUtil;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportSynchronization;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.UserPropertyFileStorage;

public class UserPropertyFileStorageFactory
implements UserStorageProviderFactory<UserPropertyFileStorage>,
ImportSynchronization {
    public static final String PROVIDER_ID = "user-password-props-arq";
    public static final String PROPERTY_FILE = "propertyFile";
    public static final String VALIDATION_PROP_FILE_NOT_CONFIGURED = "user property file is not configured";
    public static final String VALIDATION_PROP_FILE_DOESNT_EXIST = "user property file does not exist";
    protected static final List<ProviderConfigProperty> CONFIG_PROPERTIES = ProviderConfigurationBuilder.create().property().name("propertyFile").type("String").label("Property File").helpText("File that contains name value pairs").defaultValue(null).add().property().name("federatedStorage").type("boolean").label("User Federated Storage").helpText("User Federated Storage").defaultValue(null).add().build();

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        String fp = (String)config.getConfig().getFirst((Object)PROPERTY_FILE);
        if (fp == null) {
            throw new ComponentValidationException(VALIDATION_PROP_FILE_NOT_CONFIGURED, new Object[0]);
        }
        File file = new File(fp = EnvUtil.replace((String)fp));
        if (!file.exists()) {
            throw new ComponentValidationException(VALIDATION_PROP_FILE_DOESNT_EXIST, new Object[0]);
        }
    }

    public UserPropertyFileStorage create(KeycloakSession session, ComponentModel model) {
        String path = (String)model.getConfig().getFirst((Object)PROPERTY_FILE);
        path = EnvUtil.replace((String)path);
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(path);){
            props.load(is);
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new UserPropertyFileStorage(session, model, props);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public SynchronizationResult sync(KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        return SynchronizationResult.ignored();
    }

    public SynchronizationResult syncSince(Date lastSync, KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        return SynchronizationResult.ignored();
    }
}

