/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.testsuite.federation.UserMapStorage;

public class UserMapStorageFactory
implements UserStorageProviderFactory<UserMapStorage> {
    public static final String PROVIDER_ID = "user-password-map-arq";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private final Map<String, String> userPasswords = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, Set<String>> userGroups = new ConcurrentHashMap<String, Set<String>>();

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public UserMapStorage create(KeycloakSession session, ComponentModel model) {
        return new UserMapStorage(session, model, this.userPasswords, this.userGroups);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public void clear() {
        this.userPasswords.clear();
        this.userGroups.clear();
    }

    static {
        ProviderConfigProperty attr = new ProviderConfigProperty("attr", "attr", "This is some attribute", "String", null);
        configProperties.add(attr);
    }
}

