/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;
import org.keycloak.storage.user.UserLookupProvider;

public class PassThroughFederatedUserStorageProvider
implements UserStorageProvider,
UserLookupProvider.Streams,
CredentialInputValidator,
CredentialInputUpdater {
    public static final Set<String> CREDENTIAL_TYPES = Collections.singleton("password");
    public static final String PASSTHROUGH_USERNAME = "passthrough";
    public static final String INITIAL_PASSWORD = "secret";
    private KeycloakSession session;
    private ComponentModel component;

    public PassThroughFederatedUserStorageProvider(KeycloakSession session, ComponentModel component) {
        this.session = session;
        this.component = component;
    }

    public Set<String> getSupportedCredentialTypes() {
        return CREDENTIAL_TYPES;
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return "password".equals(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (input.getType().equals("password")) {
            if (INITIAL_PASSWORD.equals(input.getChallengeResponse())) {
                return true;
            }
            return this.session.userFederatedStorage().getStoredCredentialsByTypeStream(realm, user.getId(), "CLEAR_TEXT_PASSWORD").map(credentialModel -> credentialModel.getSecretData()).anyMatch(Predicate.isEqual("{\"value\":\"" + input.getChallengeResponse() + "\"}"));
        }
        return false;
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (input.getType().equals("password")) {
            Optional existing = this.session.userFederatedStorage().getStoredCredentialsByTypeStream(realm, user.getId(), "CLEAR_TEXT_PASSWORD").findFirst();
            if (existing.isPresent()) {
                CredentialModel model = (CredentialModel)existing.get();
                model.setType("CLEAR_TEXT_PASSWORD");
                model.setSecretData("{\"value\":\"" + input.getChallengeResponse() + "\"}");
                this.session.userFederatedStorage().updateCredential(realm, user.getId(), model);
            } else {
                CredentialModel model = new CredentialModel();
                model.setType("CLEAR_TEXT_PASSWORD");
                model.setSecretData("{\"value\":\"" + input.getChallengeResponse() + "\"}");
                this.session.userFederatedStorage().createCredential(realm, user.getId(), model);
            }
            return true;
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        this.session.userFederatedStorage().getStoredCredentialsByTypeStream(realm, user.getId(), "CLEAR_TEXT_PASSWORD").collect(Collectors.toList()).forEach(credModel -> this.session.userFederatedStorage().removeStoredCredential(realm, user.getId(), credModel.getId()));
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return CREDENTIAL_TYPES;
    }

    public void close() {
    }

    public UserModel getUserById(RealmModel realm, String id) {
        if (!StorageId.externalId((String)id).equals(PASSTHROUGH_USERNAME)) {
            return null;
        }
        return this.getUserModel(realm);
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        if (!PASSTHROUGH_USERNAME.equals(username)) {
            return null;
        }
        return this.getUserModel(realm);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        Optional<StorageId> result = this.session.userFederatedStorage().getUsersByUserAttributeStream(realm, AbstractUserAdapterFederatedStorage.EMAIL_ATTRIBUTE, email).map(StorageId::new).filter(storageId -> Objects.equals(storageId.getExternalId(), PASSTHROUGH_USERNAME)).filter(storageId -> Objects.equals(storageId.getProviderId(), this.component.getId())).findFirst();
        return result.isPresent() ? this.getUserModel(realm) : null;
    }

    private UserModel getUserModel(RealmModel realm) {
        return new AbstractUserAdapterFederatedStorage.Streams(this.session, realm, this.component){

            public String getUsername() {
                return PassThroughFederatedUserStorageProvider.PASSTHROUGH_USERNAME;
            }

            public void setUsername(String username) {
            }
        };
    }
}

