/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.role.RoleStorageProvider;
import org.keycloak.storage.role.RoleStorageProviderModel;
import org.keycloak.testsuite.federation.HardcodedClientStorageProvider;

public class HardcodedRoleStorageProvider
implements RoleStorageProvider {
    private final RoleStorageProviderModel component;
    private final String roleName;

    public HardcodedRoleStorageProvider(RoleStorageProviderModel component) {
        this.component = component;
        this.roleName = (String)component.getConfig().getFirst((Object)"role_name");
    }

    public void close() {
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        if (this.roleName.equals(name)) {
            return new HardcodedRoleAdapter(realm);
        }
        return null;
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String roleName = storageId.getExternalId();
        if (this.roleName.equals(roleName)) {
            return new HardcodedRoleAdapter(realm);
        }
        return null;
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        if (Boolean.parseBoolean((String)this.component.getConfig().getFirst((Object)"delayed_search"))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HardcodedClientStorageProvider.class).warn((Object)ex.getCause());
                return Stream.empty();
            }
        }
        if (search != null && this.roleName.toLowerCase().contains(search.toLowerCase())) {
            return Stream.of(new HardcodedRoleAdapter(realm));
        }
        return Stream.empty();
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class HardcodedRoleAdapter
    implements RoleModel {
        private final RealmModel realm;
        private StorageId storageId;

        public HardcodedRoleAdapter(RealmModel realm) {
            this.realm = realm;
        }

        public String getId() {
            if (this.storageId == null) {
                this.storageId = new StorageId(HardcodedRoleStorageProvider.this.component.getId(), this.getName());
            }
            return this.storageId.getId();
        }

        public String getName() {
            return HardcodedRoleStorageProvider.this.roleName;
        }

        public String getDescription() {
            return "Federated Role";
        }

        public boolean isComposite() {
            return false;
        }

        public Stream<RoleModel> getCompositesStream(String search, Integer first, Integer max) {
            return Stream.empty();
        }

        public boolean isClientRole() {
            return false;
        }

        public String getContainerId() {
            return this.realm.getId();
        }

        public RoleContainerModel getContainer() {
            return this.realm;
        }

        public boolean hasRole(RoleModel role) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFirstAttribute(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Stream<String> getAttributeStream(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, List<String>> getAttributes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setDescription(String description) {
            throw new ReadOnlyException("role is read only");
        }

        public void setName(String name) {
            throw new ReadOnlyException("role is read only");
        }

        public void addCompositeRole(RoleModel role) {
            throw new ReadOnlyException("role is read only");
        }

        public void removeCompositeRole(RoleModel role) {
            throw new ReadOnlyException("role is read only");
        }

        public void setSingleAttribute(String name, String value) {
            throw new ReadOnlyException("role is read only");
        }

        public void setAttribute(String name, List<String> values) {
            throw new ReadOnlyException("role is read only");
        }

        public void removeAttribute(String name) {
            throw new ReadOnlyException("role is read only");
        }
    }
}

