/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.List;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.group.GroupStorageProviderFactory;
import org.keycloak.storage.group.GroupStorageProviderModel;
import org.keycloak.testsuite.federation.HardcodedGroupStorageProvider;

public class HardcodedGroupStorageProviderFactory
implements GroupStorageProviderFactory<HardcodedGroupStorageProvider> {
    public static final String PROVIDER_ID = "hardcoded-group";
    public static final String GROUP_NAME = "gorup_name";
    public static final String DELAYED_SEARCH = "delayed_search";
    protected static final List<ProviderConfigProperty> CONFIG_PROPERTIES = ProviderConfigurationBuilder.create().property().name("gorup_name").type("String").label("Hardcoded Group Name").helpText("Only this group name is available for lookup").defaultValue((Object)"hardcoded-group").add().property().name("delayed_search").type("boolean").label("Delayes provider by 5s.").helpText("If true it delayes search for clients within the provider by 5s.").defaultValue((Object)"false").add().build();

    public HardcodedGroupStorageProvider create(KeycloakSession session, ComponentModel model) {
        return new HardcodedGroupStorageProvider(new GroupStorageProviderModel(model));
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

