/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.AbstractReadOnlyClientStorageAdapter;
import org.keycloak.storage.client.ClientLookupProvider;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.client.ClientStorageProviderModel;

public class HardcodedClientStorageProvider
implements ClientStorageProvider,
ClientLookupProvider {
    protected KeycloakSession session;
    protected ClientStorageProviderModel component;
    protected String clientId;
    protected String redirectUri;
    protected boolean consent;

    public HardcodedClientStorageProvider(KeycloakSession session, ClientStorageProviderModel component) {
        this.session = session;
        this.component = component;
        this.clientId = (String)component.getConfig().getFirst((Object)"client_id");
        this.redirectUri = (String)component.getConfig().getFirst((Object)"redirect_uri");
        this.consent = "true".equals(component.getConfig().getFirst((Object)"consent"));
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String clientId = storageId.getExternalId();
        if (this.clientId.equals(clientId)) {
            return new ClientAdapter(realm);
        }
        return null;
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        if (this.clientId.equals(clientId)) {
            return new ClientAdapter(realm);
        }
        return null;
    }

    public void close() {
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        if (Boolean.parseBoolean((String)this.component.getConfig().getFirst((Object)"delayed_search"))) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(HardcodedClientStorageProvider.class).warn((Object)ex.getCause());
                return Stream.empty();
            }
        }
        if (clientId != null && this.clientId.toLowerCase().contains(clientId.toLowerCase())) {
            return Stream.of(new ClientAdapter(realm));
        }
        return Stream.empty();
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScope) {
        if (defaultScope) {
            ClientScopeModel rolesScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"roles");
            ClientScopeModel webOriginsScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"web-origins");
            return Arrays.asList(rolesScope, webOriginsScope).stream().collect(Collectors.toMap(ClientScopeModel::getName, clientScope -> clientScope));
        }
        ClientScopeModel offlineScope = KeycloakModelUtils.getClientScopeByName((RealmModel)realm, (String)"offline_access");
        return Collections.singletonMap("offline_access", offlineScope);
    }

    public class ClientAdapter
    extends AbstractReadOnlyClientStorageAdapter {
        public ClientAdapter(RealmModel realm) {
            super(HardcodedClientStorageProvider.this.session, realm, HardcodedClientStorageProvider.this.component);
        }

        public String getClientId() {
            return HardcodedClientStorageProvider.this.clientId;
        }

        public String getName() {
            return "Federated Client";
        }

        public String getDescription() {
            return "Pulled in from client storage provider";
        }

        public boolean isEnabled() {
            return true;
        }

        public boolean isAlwaysDisplayInConsole() {
            return false;
        }

        public Set<String> getWebOrigins() {
            return Collections.EMPTY_SET;
        }

        public Set<String> getRedirectUris() {
            HashSet<String> set = new HashSet<String>();
            set.add(HardcodedClientStorageProvider.this.redirectUri);
            return set;
        }

        public String getManagementUrl() {
            return null;
        }

        public String getRootUrl() {
            return null;
        }

        public String getBaseUrl() {
            return null;
        }

        public boolean isBearerOnly() {
            return false;
        }

        public int getNodeReRegistrationTimeout() {
            return 0;
        }

        public String getClientAuthenticatorType() {
            return null;
        }

        public boolean validateSecret(String secret) {
            return "password".equals(secret);
        }

        public String getSecret() {
            return "password";
        }

        public String getRegistrationToken() {
            return null;
        }

        public String getProtocol() {
            return "openid-connect";
        }

        public String getAttribute(String name) {
            return null;
        }

        public Map<String, String> getAttributes() {
            return Collections.EMPTY_MAP;
        }

        public String getAuthenticationFlowBindingOverride(String binding) {
            return null;
        }

        public Map<String, String> getAuthenticationFlowBindingOverrides() {
            return Collections.EMPTY_MAP;
        }

        public boolean isFrontchannelLogout() {
            return false;
        }

        public boolean isPublicClient() {
            return false;
        }

        public boolean isConsentRequired() {
            return HardcodedClientStorageProvider.this.consent;
        }

        public boolean isStandardFlowEnabled() {
            return true;
        }

        public boolean isImplicitFlowEnabled() {
            return true;
        }

        public boolean isDirectAccessGrantsEnabled() {
            return true;
        }

        public boolean isServiceAccountsEnabled() {
            return false;
        }

        public Map<String, ClientScopeModel> getClientScopes(boolean defaultScope) {
            return this.session.clients().getClientScopes(this.getRealm(), (ClientModel)this, defaultScope);
        }

        public int getNotBefore() {
            return 0;
        }

        public Stream<ProtocolMapperModel> getProtocolMappersStream() {
            return Stream.empty();
        }

        public ProtocolMapperModel getProtocolMapperById(String id) {
            return null;
        }

        public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
            return null;
        }

        public boolean isFullScopeAllowed() {
            return false;
        }

        public Stream<RoleModel> getScopeMappingsStream() {
            return Stream.of(this.realm.getRole("offline_access"));
        }

        public Stream<RoleModel> getRealmScopeMappingsStream() {
            return Stream.empty();
        }

        public boolean hasScope(RoleModel role) {
            return false;
        }
    }
}

