/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.clientscope.ClientScopeLookupProvider;
import org.keycloak.storage.clientscope.ClientScopeStorageProvider;
import org.keycloak.storage.clientscope.ClientScopeStorageProviderModel;

public class HardcodedClientScopeStorageProvider
implements ClientScopeStorageProvider,
ClientScopeLookupProvider {
    private final ClientScopeStorageProviderModel component;
    private final String clientScopeName;

    public HardcodedClientScopeStorageProvider(KeycloakSession session, ClientScopeStorageProviderModel component) {
        this.component = component;
        this.clientScopeName = (String)component.getConfig().getFirst((Object)"scope_name");
    }

    public ClientScopeModel getClientScopeById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String scopeName = storageId.getExternalId();
        if (this.clientScopeName.equals(scopeName)) {
            return new HardcodedClientScopeAdapter(realm);
        }
        return null;
    }

    public void close() {
    }

    public class HardcodedClientScopeAdapter
    implements ClientScopeModel {
        private final RealmModel realm;
        private StorageId storageId;

        public HardcodedClientScopeAdapter(RealmModel realm) {
            this.realm = realm;
        }

        public String getId() {
            if (this.storageId == null) {
                this.storageId = new StorageId(HardcodedClientScopeStorageProvider.this.component.getId(), this.getName());
            }
            return this.storageId.getId();
        }

        public String getName() {
            return HardcodedClientScopeStorageProvider.this.clientScopeName;
        }

        public RealmModel getRealm() {
            return this.realm;
        }

        public void setName(String name) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getDescription() {
            return "Federated client scope";
        }

        public void setDescription(String description) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getProtocol() {
            return "openid-connect";
        }

        public void setProtocol(String protocol) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void setAttribute(String name, String value) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void removeAttribute(String name) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getAttribute(String name) {
            return null;
        }

        public Map<String, String> getAttributes() {
            return Collections.EMPTY_MAP;
        }

        public Stream<ProtocolMapperModel> getProtocolMappersStream() {
            return Stream.empty();
        }

        public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void removeProtocolMapper(ProtocolMapperModel mapping) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void updateProtocolMapper(ProtocolMapperModel mapping) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public ProtocolMapperModel getProtocolMapperById(String id) {
            return null;
        }

        public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
            return null;
        }

        public Stream<RoleModel> getScopeMappingsStream() {
            return Stream.empty();
        }

        public Stream<RoleModel> getRealmScopeMappingsStream() {
            return Stream.empty();
        }

        public void addScopeMapping(RoleModel role) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void deleteScopeMapping(RoleModel role) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean hasScope(RoleModel role) {
            return false;
        }
    }
}

