/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;

public class FailableHardcodedStorageProvider
implements UserStorageProvider,
UserLookupProvider.Streams,
UserQueryProvider.Streams,
ImportedUserValidation,
CredentialInputUpdater.Streams,
CredentialInputValidator {
    public static String username = "billb";
    public static String password = "password";
    public static String email = "billb@nowhere.com";
    public static String first = "Bill";
    public static String last = "Burke";
    public static MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    public static boolean fail;
    protected ComponentModel model;
    protected KeycloakSession session;
    protected boolean componentFail;

    public FailableHardcodedStorageProvider(ComponentModel model, KeycloakSession session) {
        this.model = model;
        this.session = session;
        this.componentFail = FailableHardcodedStorageProvider.isInFailMode(model);
    }

    public static boolean isInFailMode(ComponentModel model) {
        return model.getConfig().getFirst((Object)"fail") != null && ((String)model.getConfig().getFirst((Object)"fail")).equalsIgnoreCase("true");
    }

    public boolean supportsCredentialType(String credentialType) {
        this.checkForceFail();
        return "password".equals(credentialType);
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        this.checkForceFail();
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (!user.getUsername().equals(username)) {
            throw new RuntimeException("UNKNOWN USER!");
        }
        if (input.getType().equals("password")) {
            password = input.getChallengeResponse();
            return true;
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        this.checkForceFail();
    }

    public Stream<String> getDisableableCredentialTypesStream(RealmModel realm, UserModel user) {
        this.checkForceFail();
        return Stream.empty();
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        this.checkForceFail();
        return "password".equals(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput credentialInput) {
        this.checkForceFail();
        if (!user.getUsername().equals("billb")) {
            throw new RuntimeException("UNKNOWN USER!");
        }
        if (credentialInput.getType().equals("password")) {
            return password != null && password.equals(credentialInput.getChallengeResponse());
        }
        return false;
    }

    public UserModel validate(RealmModel realm, UserModel user) {
        this.checkForceFail();
        return new Delegate(user);
    }

    public UserModel getUserById(RealmModel realm, String id) {
        this.checkForceFail();
        throw new RuntimeException("THIS IMPORTS  SHOULD NEVER BE CALLED");
    }

    public UserModel getUserByUsername(RealmModel realm, String uname) {
        this.checkForceFail();
        if (!username.equals(uname)) {
            return null;
        }
        UserModel local = this.session.userLocalStorage().getUserByUsername(realm, uname);
        if (local != null && !this.model.getId().equals(local.getFederationLink())) {
            throw new RuntimeException("local storage has wrong federation link");
        }
        if (local != null) {
            return new Delegate(local);
        }
        local = this.session.userLocalStorage().addUser(realm, uname);
        local.setEnabled(true);
        local.setFirstName(first);
        local.setLastName(last);
        local.setEmail(email);
        local.setFederationLink(this.model.getId());
        for (String key : attributes.keySet()) {
            List values = (List)attributes.get((Object)key);
            if (values == null) continue;
            local.setAttribute(key, values);
        }
        return new Delegate(local);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        this.checkForceFail();
        return null;
    }

    protected void checkForceFail() {
        if (fail || this.componentFail) {
            FailableHardcodedStorageProvider.throwFailure();
        }
    }

    public static void throwFailure() {
        throw new RuntimeException("FORCED FAILURE");
    }

    public int getUsersCount(RealmModel realm) {
        this.checkForceFail();
        return 1;
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        this.checkForceFail();
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        this.checkForceFail();
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search) {
        this.checkForceFail();
        if (!search.equals(username)) {
            return Stream.empty();
        }
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        this.checkForceFail();
        if (!search.equals(username)) {
            return Stream.empty();
        }
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params) {
        this.checkForceFail();
        if (!username.equals(params.get("username"))) {
            return Stream.empty();
        }
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> params, Integer firstResult, Integer maxResults) {
        this.checkForceFail();
        if (!username.equals(params.get("username"))) {
            return Stream.empty();
        }
        UserModel model = this.getUserByUsername(realm, username);
        return model != null ? Stream.of(model) : Stream.empty();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        this.checkForceFail();
        return Stream.empty();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        this.checkForceFail();
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        this.checkForceFail();
        return Stream.empty();
    }

    public void close() {
    }

    private static class Delegate
    extends UserModelDelegate {
        public Delegate(UserModel delegate) {
            super(delegate);
        }

        public void setUsername(String name) {
            super.setUsername(name);
            username = name;
        }

        public void setSingleAttribute(String name, String value) {
            super.setSingleAttribute(name, value);
            attributes.putSingle((Object)name, (Object)value);
        }

        public void setAttribute(String name, List<String> values) {
            super.setAttribute(name, values);
            attributes.put((Object)name, values);
        }

        public void removeAttribute(String name) {
            super.removeAttribute(name);
            attributes.remove((Object)name);
        }

        public void setFirstName(String firstName) {
            super.setFirstName(firstName);
            first = firstName;
        }

        public void setLastName(String lastName) {
            super.setLastName(lastName);
            last = lastName;
        }

        public void setEmail(String em) {
            super.setEmail(em);
            email = em;
        }
    }
}

