/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.user.ImportSynchronization;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.testsuite.federation.DummyUserFederationProvider;

public class DummyUserFederationProviderFactory
implements UserStorageProviderFactory<DummyUserFederationProvider>,
ImportSynchronization {
    private static final Logger logger = Logger.getLogger(DummyUserFederationProviderFactory.class);
    public static final String PROVIDER_NAME = "dummy";
    private AtomicInteger fullSyncCounter = new AtomicInteger();
    private AtomicInteger changedSyncCounter = new AtomicInteger();
    private Map<String, UserModel> users = new HashMap<String, UserModel>();

    public DummyUserFederationProvider create(KeycloakSession session, ComponentModel model) {
        return new DummyUserFederationProvider(session, model, this.users);
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return ProviderConfigurationBuilder.create().property().name("important.config").type("String").add().build();
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    public SynchronizationResult sync(KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        logger.info((Object)"syncAllUsers invoked");
        this.fullSyncCounter.incrementAndGet();
        return SynchronizationResult.empty();
    }

    public SynchronizationResult syncSince(Date lastSync, KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        logger.info((Object)"syncChangedUsers invoked");
        this.changedSyncCounter.incrementAndGet();
        return SynchronizationResult.empty();
    }

    public int getFullSyncCounter() {
        return this.fullSyncCounter.get();
    }

    public int getChangedSyncCounter() {
        return this.changedSyncCounter.get();
    }
}

