/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class DummyUserFederationProvider
implements UserStorageProvider,
UserLookupProvider.Streams,
UserRegistrationProvider,
CredentialInputValidator {
    private final Map<String, UserModel> users;
    private KeycloakSession session;
    private ComponentModel component;
    public static final String HARDCODED_PASSWORD = "secret";
    public static final String HARDCODED_OTP = "123456";

    public DummyUserFederationProvider(KeycloakSession session, ComponentModel component, Map<String, UserModel> users) {
        this.users = users;
        this.session = session;
        this.component = component;
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserModel local = this.session.userLocalStorage().addUser(realm, username);
        local.setFederationLink(this.component.getId());
        this.users.put(username, local);
        return local;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.users.remove(user.getUsername()) != null;
    }

    public UserModel getUserById(RealmModel realm, String id) {
        return null;
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        return this.users.get(username);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(Arrays.asList("password", "otp"));
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        if (!this.supportsCredentialType(credentialType)) {
            return false;
        }
        return user.getUsername().equals("test-user");
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput credentialInput) {
        if (user.getUsername().equals("test-user")) {
            if ("password".equals(credentialInput.getType())) {
                return HARDCODED_PASSWORD.equals(credentialInput.getChallengeResponse());
            }
            if ("otp".equals(credentialInput.getType())) {
                return HARDCODED_OTP.equals(credentialInput.getChallengeResponse());
            }
        }
        return false;
    }

    public void close() {
    }
}

