/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.testsuite.federation.BackwardsCompatibilityUserStorage;

public class BackwardsCompatibilityUserStorageFactory
implements UserStorageProviderFactory<BackwardsCompatibilityUserStorage> {
    public static final String PROVIDER_ID = "backwards-compatibility-storage";
    private final Map<String, BackwardsCompatibilityUserStorage.MyUser> userPasswords = new ConcurrentHashMap<String, BackwardsCompatibilityUserStorage.MyUser>();

    public BackwardsCompatibilityUserStorage create(KeycloakSession session, ComponentModel model) {
        return new BackwardsCompatibilityUserStorage(session, model, this.userPasswords);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean hasUserOTP(String username) {
        BackwardsCompatibilityUserStorage.MyUser user = this.userPasswords.get(username);
        if (user == null) {
            return false;
        }
        return user.getOtp() != null;
    }
}

