/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.events;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.EventListenerTransaction;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;

public class TestEventsListenerProvider
implements EventListenerProvider {
    private static final BlockingQueue<Event> events = new LinkedBlockingQueue<Event>();
    private static final BlockingQueue<AdminEvent> adminEvents = new LinkedBlockingQueue<AdminEvent>();
    private final EventListenerTransaction tx = new EventListenerTransaction((event, includeRepre) -> adminEvents.add((AdminEvent)event), events::add);

    public TestEventsListenerProvider(KeycloakSession session) {
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public void onEvent(Event event) {
        this.tx.addEvent(event);
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        this.tx.addAdminEvent(event, includeRepresentation);
    }

    public void close() {
    }

    public static Event poll() {
        return (Event)events.poll();
    }

    public static AdminEvent pollAdminEvent() {
        return (AdminEvent)adminEvents.poll();
    }

    public static void clear() {
        events.clear();
    }

    public static void clearAdminEvents() {
        adminEvents.clear();
    }
}

