/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.components;

import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.testsuite.components.TestProvider;
import org.keycloak.testsuite.components.TestProviderFactory;

public class TestImplProviderFactory
implements TestProviderFactory {
    private List<ProviderConfigProperty> config = ProviderConfigurationBuilder.create().property("secret", "Secret", "A secret value", "String", null, null, true).property("number", "Number", "A number value", "String", null, null, false).property("required", "Required", "A required value", "String", null, null, false).property("val1", "Value 1", "Some more values", "String", null, null, false).property("val2", "Value 2", "Some more values", "String", null, null, false).property("val3", "Value 3", "Some more values", "String", null, null, false).build();

    public Object create(KeycloakSession session, ComponentModel model) {
        return new TestImplProvider(model);
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkRequired("required", "Required").checkInt("number", "Number", false);
    }

    public String getHelpText() {
        return "Provider to test component storage";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.config;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "test";
    }

    public static class TestImplProvider
    implements TestProvider {
        private ComponentModel model;

        public TestImplProvider(ComponentModel model) {
            this.model = model;
        }

        @Override
        public TestProvider.DetailsRepresentation getDetails() {
            TestProvider.DetailsRepresentation rep = new TestProvider.DetailsRepresentation();
            rep.setConfig((Map<String, List<String>>)this.model.getConfig());
            return rep;
        }

        public void close() {
        }
    }
}

