/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.testsuite.authentication.ExpectedParamAuthenticator;

public class ExpectedParamAuthenticatorFactory
implements AuthenticatorFactory,
ConfigurableAuthenticatorFactory {
    public static final String PROVIDER_ID = "expected-param-authenticator";
    private static final ExpectedParamAuthenticator SINGLETON = new ExpectedParamAuthenticator();
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.ALTERNATIVE, AuthenticationExecutionModel.Requirement.DISABLED};
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return PROVIDER_ID;
    }

    public Authenticator create(KeycloakSession session) {
        return SINGLETON;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public boolean isConfigurable() {
        return true;
    }

    public String getHelpText() {
        return "You will be approved if you send query string parameter 'foo' with expected value.";
    }

    public String getDisplayType() {
        return "TEST: Expected Parameter";
    }

    public String getReferenceCategory() {
        return "Expected Parameter";
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("expected_value");
        property.setLabel("Expected query parameter value");
        property.setType("String");
        property.setHelpText("Expected value of query parameter foo. Authenticator will success if request to OIDC authz endpoint has this parameter");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("logged_user");
        property.setLabel("Automatically logged user");
        property.setType("String");
        property.setHelpText("This user will be successfully authenticated automatically when present");
        configProperties.add(property);
    }
}

