/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.authentication;

import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ExpectedParamAuthenticator
implements Authenticator {
    public static final String EXPECTED_VALUE = "expected_value";
    public static final String LOGGED_USER = "logged_user";
    private static final Logger logger = Logger.getLogger(ExpectedParamAuthenticator.class);

    public void authenticate(AuthenticationFlowContext context) {
        String paramValue = context.getAuthenticationSession().getClientNote("client_request_param_foo");
        String expectedValue = (String)context.getAuthenticatorConfig().getConfig().get(EXPECTED_VALUE);
        logger.info((Object)("Value: " + paramValue + ", expectedValue: " + expectedValue));
        if (paramValue != null && paramValue.equals(expectedValue)) {
            String loggedUser = (String)context.getAuthenticatorConfig().getConfig().get(LOGGED_USER);
            if (loggedUser == null) {
                logger.info((Object)"Successfully authenticated, but don't set any authenticated user");
            } else {
                UserModel user = context.getSession().users().getUserByUsername(context.getRealm(), loggedUser);
                logger.info((Object)("Successfully authenticated as user " + user.getUsername()));
                context.setUser(user);
            }
            context.success();
        } else {
            context.attempted();
        }
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

