/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.services.clientpolicy.executor;

import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyEvent;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class TestRaiseExeptionExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    private static final Logger logger = Logger.getLogger(TestRaiseExeptionExecutor.class);
    protected final KeycloakSession session;

    public TestRaiseExeptionExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "test-raise-exception";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        if (this.isThrowExceptionNeeded(context.getEvent())) {
            throw new ClientPolicyException(context.getEvent().toString(), "Exception thrown intentionally");
        }
    }

    private boolean isThrowExceptionNeeded(ClientPolicyEvent event) {
        logger.tracev("Client Policy Trigger Event = {0}", (Object)event);
        switch (event) {
            case REGISTERED: 
            case UPDATED: 
            case UNREGISTER: 
            case SERVICE_ACCOUNT_TOKEN_REQUEST: 
            case BACKCHANNEL_AUTHENTICATION_REQUEST: 
            case BACKCHANNEL_TOKEN_REQUEST: 
            case PUSHED_AUTHORIZATION_REQUEST: 
            case DEVICE_AUTHORIZATION_REQUEST: 
            case DEVICE_TOKEN_REQUEST: {
                return true;
            }
        }
        return false;
    }
}

