/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.runonserver;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ComponentRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.testsuite.runonserver.FetchOnServer;
import org.keycloak.testsuite.runonserver.FetchOnServerWrapper;

public class RunHelpers {
    public static FetchOnServerWrapper<RealmRepresentation> internalRealm() {
        return new FetchOnServerWrapper(){

            @Override
            public FetchOnServer getRunOnServer() {
                return session -> ModelToRepresentation.toRepresentation((KeycloakSession)session, (RealmModel)session.getContext().getRealm(), (boolean)true);
            }

            public Class<RealmRepresentation> getResultClass() {
                return RealmRepresentation.class;
            }
        };
    }

    public static FetchOnServerWrapper<ComponentRepresentation> internalComponent(final String componentId) {
        return new FetchOnServerWrapper(){

            @Override
            public FetchOnServer getRunOnServer() {
                return session -> ModelToRepresentation.toRepresentation((KeycloakSession)session, (ComponentModel)session.getContext().getRealm().getComponent(componentId), (boolean)true);
            }

            public Class<ComponentRepresentation> getResultClass() {
                return ComponentRepresentation.class;
            }
        };
    }

    public static FetchOnServerWrapper<CredentialModel> fetchCredentials(final String username) {
        return new FetchOnServerWrapper(){

            @Override
            public FetchOnServer getRunOnServer() {
                return session -> {
                    RealmModel realm = session.getContext().getRealm();
                    UserModel user = session.users().getUserByUsername(realm, username);
                    List storedCredentialsByType = session.userCredentialManager().getStoredCredentialsByTypeStream(realm, user, "password").collect(Collectors.toList());
                    System.out.println(storedCredentialsByType.size());
                    return storedCredentialsByType.get(0);
                };
            }

            public Class getResultClass() {
                return CredentialModel.class;
            }
        };
    }
}

