/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.keycloak.headers.SecurityHeadersProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.testsuite.rest.TestingResourceProvider;
import org.keycloak.testsuite.util.ServerURLs;

public class TestJavascriptResource {
    private KeycloakSession session;

    public TestJavascriptResource(KeycloakSession session) {
        this.session = session;
    }

    @GET
    @Path(value="/js/keycloak.js")
    @Produces(value={"application/javascript"})
    public String getJavascriptAdapter() throws IOException {
        return this.resourceToString("/javascript/keycloak.js");
    }

    @GET
    @Path(value="/index.html")
    @Produces(value={"text/html"})
    public String getJavascriptTestingEnvironment() throws IOException {
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().skipHeaders();
        return this.resourceToString("/javascript/index.html");
    }

    @GET
    @Path(value="/init-in-head.html")
    @Produces(value={"text/html"})
    public String getJavascriptTestingEnvironmentWithInitInHead() throws IOException {
        ((SecurityHeadersProvider)this.session.getProvider(SecurityHeadersProvider.class)).options().skipHeaders();
        return this.resourceToString("/javascript/init-in-head.html");
    }

    @GET
    @Path(value="/silent-check-sso.html")
    @Produces(value={"text/html"})
    public String getJavascriptTestingEnvironmentSilentCheckSso() throws IOException {
        return this.resourceToString("/javascript/silent-check-sso.html");
    }

    @GET
    @Path(value="/keycloak.json")
    @Produces(value={"application/json"})
    public String getKeycloakJSON() throws IOException {
        return this.resourceToString("/javascript/keycloak.json");
    }

    private String resourceToString(String path) throws IOException {
        try (InputStream is = TestingResourceProvider.class.getResourceAsStream(path);){
            String string;
            try (BufferedReader buf = new BufferedReader(new InputStreamReader(is));){
                String line = buf.readLine();
                StringBuilder sb = new StringBuilder();
                while (line != null) {
                    sb.append(line).append("\n");
                    line = buf.readLine();
                }
                string = sb.toString().replace("${js-adapter.auth-server-url}", ServerURLs.getAuthServerContextRoot() + "/auth");
            }
            return string;
        }
    }
}

