/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.rest;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.util.HtmlUtils;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.grants.ciba.endpoints.ClientNotificationEndpointRequest;
import org.keycloak.representations.LogoutToken;
import org.keycloak.representations.adapters.action.LogoutAction;
import org.keycloak.representations.adapters.action.PushNotBeforeAction;
import org.keycloak.representations.adapters.action.TestAvailabilityAction;
import org.keycloak.services.resource.RealmResourceProvider;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.testsuite.rest.TestApplicationResourceProviderFactory;
import org.keycloak.testsuite.rest.representation.TestAuthenticationChannelRequest;
import org.keycloak.testsuite.rest.resource.TestingOIDCEndpointsApplicationResource;

public class TestApplicationResourceProvider
implements RealmResourceProvider {
    private KeycloakSession session;
    private final BlockingQueue<LogoutAction> adminLogoutActions;
    private final BlockingQueue<LogoutToken> frontChannelLogoutTokens;
    private final BlockingQueue<LogoutToken> backChannelLogoutTokens;
    private final BlockingQueue<PushNotBeforeAction> adminPushNotBeforeActions;
    private final BlockingQueue<TestAvailabilityAction> adminTestAvailabilityAction;
    private final TestApplicationResourceProviderFactory.OIDCClientData oidcClientData;
    private final ConcurrentMap<String, TestAuthenticationChannelRequest> authenticationChannelRequests;
    private final ConcurrentMap<String, ClientNotificationEndpointRequest> cibaClientNotifications;
    @Context
    HttpRequest request;

    public TestApplicationResourceProvider(KeycloakSession session, BlockingQueue<LogoutAction> adminLogoutActions, BlockingQueue<LogoutToken> backChannelLogoutTokens, BlockingQueue<LogoutToken> frontChannelLogoutTokens, BlockingQueue<PushNotBeforeAction> adminPushNotBeforeActions, BlockingQueue<TestAvailabilityAction> adminTestAvailabilityAction, TestApplicationResourceProviderFactory.OIDCClientData oidcClientData, ConcurrentMap<String, TestAuthenticationChannelRequest> authenticationChannelRequests, ConcurrentMap<String, ClientNotificationEndpointRequest> cibaClientNotifications) {
        this.session = session;
        this.adminLogoutActions = adminLogoutActions;
        this.backChannelLogoutTokens = backChannelLogoutTokens;
        this.frontChannelLogoutTokens = frontChannelLogoutTokens;
        this.adminPushNotBeforeActions = adminPushNotBeforeActions;
        this.adminTestAvailabilityAction = adminTestAvailabilityAction;
        this.oidcClientData = oidcClientData;
        this.authenticationChannelRequests = authenticationChannelRequests;
        this.cibaClientNotifications = cibaClientNotifications;
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/admin/k_logout")
    public void adminLogout(String data) throws JWSInputException {
        this.adminLogoutActions.add((LogoutAction)new JWSInput(data).readJsonContent(LogoutAction.class));
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/admin/backchannelLogout")
    public void backchannelLogout() throws JWSInputException {
        this.backChannelLogoutTokens.add((LogoutToken)new JWSInput((String)this.request.getDecodedFormParameters().getFirst((Object)"logout_token")).readJsonContent(LogoutToken.class));
    }

    @GET
    @Path(value="/admin/frontchannelLogout")
    public void frontchannelLogout(@QueryParam(value="sid") String sid, @QueryParam(value="iss") String issuer) {
        LogoutToken token = new LogoutToken();
        token.setSid(sid);
        token.issuer(issuer);
        this.frontChannelLogoutTokens.add(token);
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/admin/k_push_not_before")
    public void adminPushNotBefore(String data) throws JWSInputException {
        this.adminPushNotBeforeActions.add((PushNotBeforeAction)new JWSInput(data).readJsonContent(PushNotBeforeAction.class));
    }

    @POST
    @Consumes(value={"text/plain; charset=utf-8"})
    @Path(value="/admin/k_test_available")
    public void testAvailable(String data) throws JWSInputException {
        this.adminTestAvailabilityAction.add((TestAvailabilityAction)new JWSInput(data).readJsonContent(TestAvailabilityAction.class));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-admin-logout")
    public LogoutAction getAdminLogoutAction() throws InterruptedException {
        return this.adminLogoutActions.poll(10L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-backchannel-logout")
    public LogoutToken getBackChannelLogoutAction() throws InterruptedException {
        return this.backChannelLogoutTokens.poll(20L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-frontchannel-logout")
    public LogoutToken getFrontChannelLogoutAction() throws InterruptedException {
        return this.frontChannelLogoutTokens.poll(20L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-admin-not-before")
    public PushNotBeforeAction getAdminPushNotBefore() throws InterruptedException {
        return this.adminPushNotBeforeActions.poll(10L, TimeUnit.SECONDS);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/poll-test-available")
    public TestAvailabilityAction getTestAvailable() throws InterruptedException {
        return this.adminTestAvailabilityAction.poll(10L, TimeUnit.SECONDS);
    }

    @POST
    @Path(value="/clear-admin-actions")
    public Response clearAdminActions() {
        this.adminLogoutActions.clear();
        this.adminPushNotBeforeActions.clear();
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html; charset=utf-8"})
    @Path(value="/{action}")
    public Response post(@PathParam(value="action") String action) {
        if ("clear-admin-actions".equals(action)) {
            return this.clearAdminActions();
        }
        MultivaluedMap formParams = this.request.getDecodedFormParameters();
        String title = "APP_REQUEST";
        if (action.equals("auth")) {
            title = "AUTH_RESPONSE";
        } else if (action.equals("logout")) {
            title = "LOGOUT_REQUEST";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>" + title + "</title></head><body>");
        sb.append("<b>Form parameters: </b><br>");
        for (String paramName : formParams.keySet()) {
            sb.append(paramName).append(": ").append("<span id=\"").append(paramName).append("\">").append(HtmlUtils.escapeAttribute((String)((String)formParams.getFirst((Object)paramName)))).append("</span><br>");
        }
        sb.append("<br>");
        UriBuilder base = UriBuilder.fromUri((String)"/auth");
        sb.append("<a href=\"" + RealmsResource.accountUrl((UriBuilder)base).build(new Object[]{"test"}).toString() + "\" id=\"account\">account</a>");
        sb.append("</body></html>");
        return Response.ok((Object)sb.toString()).build();
    }

    @GET
    @Produces(value={"text/html; charset=utf-8"})
    @Path(value="/{action}")
    public String get(@PathParam(value="action") String action) {
        String title = "APP_REQUEST";
        if (action.equals("auth")) {
            title = "AUTH_RESPONSE";
        } else if (action.equals("logout")) {
            title = "LOGOUT_REQUEST";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>" + title + "</title></head><body>");
        UriBuilder base = UriBuilder.fromUri((String)"/auth");
        sb.append("<a href=\"" + RealmsResource.accountUrl((UriBuilder)base).build(new Object[]{"test"}).toString() + "\" id=\"account\">account</a>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @GET
    @NoCache
    @Produces(value={"text/html; charset=utf-8"})
    @Path(value="/get-account-profile")
    public String getAccountProfile(@QueryParam(value="token") String token, @QueryParam(value="account-uri") String accountUri) {
        StringBuilder sb = new StringBuilder();
        sb.append("function getProfile() {\n");
        sb.append(" var req = new XMLHttpRequest();\n");
        sb.append(" req.open('GET', '" + accountUri + "', false);\n");
        if (token != null) {
            sb.append(" req.setRequestHeader('Authorization', 'Bearer " + token + "');\n");
        }
        sb.append(" req.setRequestHeader('Accept', 'application/json');\n");
        sb.append(" req.send(null);\n");
        sb.append(" document.getElementById('profileOutput').innerHTML=\"<span id='innerOutput'>\" + req.status + '///' + req.responseText; + \"</span>\"\n");
        sb.append("}");
        String jsScript = sb.toString();
        sb = new StringBuilder();
        sb.append("<html><head><title>Account Profile JS Test</title><script>\n").append(jsScript).append("</script></head>\n").append("<body onload='getProfile()'><div id='profileOutput'></div></body>").append("</html>");
        return sb.toString();
    }

    @Path(value="/oidc-client-endpoints")
    public TestingOIDCEndpointsApplicationResource getTestingOIDCClientEndpoints() {
        return new TestingOIDCEndpointsApplicationResource(this.oidcClientData, this.authenticationChannelRequests, this.cibaClientNotifications);
    }

    public Object getResource() {
        return this;
    }

    public void close() {
    }
}

