/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.sessions.AuthenticationSessionModel;

public class SetClientNoteAuthenticator
implements Authenticator,
AuthenticatorFactory {
    protected static final Logger logger = Logger.getLogger(SetClientNoteAuthenticator.class);
    public static final String PROVIDER_ID = "set-client-note-authenticator";
    public static final String PREFIX = "note-";
    public static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED};

    public void authenticate(AuthenticationFlowContext context) {
        MultivaluedMap inputData = context.getHttpRequest().getDecodedFormParameters();
        AuthenticationSessionModel authSession = context.getAuthenticationSession();
        inputData.keySet().stream().filter(paramName -> paramName.startsWith(PREFIX)).forEach(paramName -> {
            String key = paramName.substring(PREFIX.length());
            String value = (String)inputData.getFirst(paramName);
            logger.infof("Set authentication session client note %s=%s", (Object)key, (Object)value);
            authSession.setClientNote(key, value);
        });
        context.success();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void action(AuthenticationFlowContext context) {
    }

    public String getDisplayType() {
        return "Set Client Note Authenticator";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Set client note of specified name with the specified value to the authenticationSession.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void close() {
    }

    public Authenticator create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

