/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.events.EventType;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class PassThroughRegistration
implements Authenticator,
AuthenticatorFactory {
    public static final String PROVIDER_ID = "testsuite-dummy-registration";
    public static String username = "new-user@localhost";
    public static String email = "new-user@localhost";
    public static final AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED};

    public void authenticate(AuthenticationFlowContext context) {
        context.getEvent().detail("username", username).detail("register_method", "form").detail("email", email);
        UserModel user = context.getSession().users().addUser(context.getRealm(), username);
        user.setEnabled(true);
        user.setEmail(email);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        context.setUser(user);
        context.getEvent().user(user);
        context.getEvent().success();
        context.newEvent().event(EventType.LOGIN);
        context.getEvent().client(context.getAuthenticationSession().getClient().getClientId()).detail("redirect_uri", context.getAuthenticationSession().getRedirectUri()).detail("auth_method", context.getAuthenticationSession().getProtocol());
        String authType = context.getAuthenticationSession().getAuthNote("auth_type");
        if (authType != null) {
            context.getEvent().detail("auth_type", authType);
        }
        context.success();
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void action(AuthenticationFlowContext context) {
    }

    public String getDisplayType() {
        return "Testsuite Dummy Pass Thru";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public String getHelpText() {
        return "Testsuite Dummy authenticator.  Just passes through and is hardcoded to a specific user";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void close() {
    }

    public Authenticator create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

