/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.provider.ProviderConfigProperty;

public class PassThroughClientAuthenticator
extends AbstractClientAuthenticator {
    public static final String PROVIDER_ID = "testsuite-client-passthrough";
    public static String clientId = "test-app";
    public static final String TEST_ERROR_PARAM = "test_error_param";
    private static final List<ProviderConfigProperty> clientConfigProperties = new ArrayList<ProviderConfigProperty>();

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        String testErrorParamVal = (String)context.getHttpRequest().getFormParameters().getFirst((Object)TEST_ERROR_PARAM);
        if (testErrorParamVal != null) {
            throw new RuntimeException(testErrorParamVal);
        }
        ClientModel client = context.getRealm().getClientByClientId(clientId);
        if (client == null) {
            context.failure(AuthenticationFlowError.CLIENT_NOT_FOUND, null);
            return;
        }
        context.getEvent().client(client);
        context.setClient(client);
        context.success();
    }

    public String getDisplayType() {
        return "Testsuite Dummy Client Validation";
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Testsuite dummy authenticator, which automatically authenticates hardcoded client (like 'test-app' )";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new LinkedList<ProviderConfigProperty>();
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return clientConfigProperties;
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("foo", "some foo value");
        props.put("bar", true);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("dummy", props);
        return config;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        return Collections.emptySet();
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("passthroughauth.foo");
        property.setLabel("Foo Property");
        property.setType("String");
        property.setHelpText("Foo Property of this authenticator, which does nothing");
        clientConfigProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName("passthroughauth.bar");
        property.setLabel("Bar Property");
        property.setType("boolean");
        property.setHelpText("Bar Property of this authenticator, which does nothing");
        clientConfigProperties.add(property);
    }
}

