/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.testsuite.federation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.adapter.AbstractUserAdapter;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.utils.StreamsUtil;

public class UserPropertyFileStorage
implements UserLookupProvider.Streams,
UserStorageProvider,
UserQueryProvider.Streams,
CredentialInputValidator {
    public static final String SEARCH_METHOD = "searchForUserStream(RealmMode, String, Integer, Integer)";
    public static final String COUNT_SEARCH_METHOD = "getUsersCount(RealmModel, String)";
    protected Properties userPasswords;
    protected ComponentModel model;
    protected KeycloakSession session;
    protected boolean federatedStorageEnabled;
    public static Map<String, List<UserPropertyFileStorageCall>> storageCalls = new HashMap<String, List<UserPropertyFileStorageCall>>();

    public UserPropertyFileStorage(KeycloakSession session, ComponentModel model, Properties userPasswords) {
        this.session = session;
        this.model = model;
        this.userPasswords = userPasswords;
        this.federatedStorageEnabled = model.getConfig().containsKey((Object)"federatedStorage") && Boolean.valueOf((String)model.getConfig().getFirst((Object)"federatedStorage")) != false;
    }

    private void addCall(String method, Integer first, Integer max) {
        storageCalls.merge(this.model.getId(), new LinkedList<UserPropertyFileStorageCall>(Collections.singletonList(new UserPropertyFileStorageCall(method, first, max))), (a, b) -> {
            a.addAll(b);
            return a;
        });
    }

    private void addCall(String method) {
        this.addCall(method, null, null);
    }

    public int getUsersCount(RealmModel realm, String search) {
        this.addCall(COUNT_SEARCH_METHOD);
        return (int)this.searchForUser(realm, search, null, null, username -> username.contains(search)).count();
    }

    public UserModel getUserById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        String username = storageId.getExternalId();
        if (!this.userPasswords.containsKey(username)) {
            return null;
        }
        return this.createUser(realm, username);
    }

    private UserModel createUser(RealmModel realm, final String username) {
        if (this.federatedStorageEnabled) {
            return new AbstractUserAdapterFederatedStorage.Streams(this.session, realm, this.model){

                public String getUsername() {
                    return username;
                }

                public void setUsername(String username2) {
                    throw new RuntimeException("Unsupported");
                }
            };
        }
        return new AbstractUserAdapter.Streams(this.session, realm, this.model){

            public String getUsername() {
                return username;
            }
        };
    }

    public UserModel getUserByUsername(RealmModel realm, String username) {
        if (!this.userPasswords.containsKey(username)) {
            return null;
        }
        return this.createUser(realm, username);
    }

    public UserModel getUserByEmail(RealmModel realm, String email) {
        return null;
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public boolean supportsCredentialType(String credentialType) {
        return credentialType.equals("password");
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return credentialType.equals("password") && this.userPasswords.get(user.getUsername()) != null;
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password")) {
            String pw = (String)this.userPasswords.get(user.getUsername());
            return pw != null && pw.equals(input.getChallengeResponse());
        }
        return false;
    }

    public int getUsersCount(RealmModel realm) {
        return this.userPasswords.size();
    }

    public Stream<UserModel> getUsersStream(RealmModel realm) {
        return this.userPasswords.keySet().stream().map(username -> this.createUser(realm, (String)username));
    }

    public Stream<UserModel> getUsersStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        if (maxResults != null && maxResults == 0) {
            return Stream.empty();
        }
        return StreamsUtil.paginatedStream(this.userPasswords.keySet().stream(), (Integer)firstResult, (Integer)maxResults).map(username -> this.createUser(realm, (String)username));
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        this.addCall(SEARCH_METHOD, firstResult, maxResults);
        return this.searchForUser(realm, search, firstResult, maxResults, username -> username.contains(search));
    }

    public Stream<UserModel> searchForUserStream(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        String search = Optional.ofNullable(attributes.get("username")).orElseGet(() -> (String)attributes.get("keycloak.session.realm.users.query.search"));
        if (search == null) {
            return Stream.empty();
        }
        Predicate<String> p = Boolean.valueOf(attributes.getOrDefault("keycloak.session.realm.users.query.exact", Boolean.FALSE.toString())) != false ? username -> username.equals(search) : username -> username.contains(search);
        return this.searchForUser(realm, search, firstResult, maxResults, p);
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public Stream<UserModel> getGroupMembersStream(RealmModel realm, GroupModel group) {
        return Stream.empty();
    }

    public Stream<UserModel> searchForUserByUserAttributeStream(RealmModel realm, String attrName, String attrValue) {
        return Stream.empty();
    }

    public void close() {
    }

    private Stream<UserModel> searchForUser(RealmModel realm, String search, Integer firstResult, Integer maxResults, Predicate<String> matcher) {
        if (maxResults != null && maxResults == 0) {
            return Stream.empty();
        }
        return StreamsUtil.paginatedStream(this.userPasswords.keySet().stream(), (Integer)firstResult, (Integer)maxResults).map(String.class::cast).filter(matcher).map(username -> this.createUser(realm, (String)username));
    }

    public static class UserPropertyFileStorageCall
    implements Serializable {
        private final String method;
        private final Integer first;
        private final Integer max;

        public UserPropertyFileStorageCall(String method, Integer first, Integer max) {
            this.method = method;
            this.first = first;
            this.max = max;
        }

        public String getMethod() {
            return this.method;
        }

        public Integer getFirst() {
            return this.first;
        }

        public Integer getMax() {
            return this.max;
        }
    }
}

